/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/03/01 14:48:37
 */
package org.asyrinx.brownie.seasar.aop;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.extension.tx.AbstractTxInterceptor;

/**
 * @author takeshi
 */
public class ServiceTxInterceptor extends AbstractTxInterceptor {

    final Log log = LogFactory.getLog(this.getClass());

    /**
     * @param transactionManager
     */
    public ServiceTxInterceptor(TransactionManager transactionManager) {
        super(transactionManager);
        log.debug("ServiceTxInterceptor <instanciated>");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        final boolean firstInvocation;
        synchronized (ServiceTxInterceptor.class) {
            firstInvocation = isFirstInvocationInThread();
            push(invocation);
        }
        try {
            if (firstInvocation) {
                return invokeNewTx(invocation);
            } else {
                return invokeOnly(invocation);
            }
        } finally {
            final MethodInvocation popped;
            synchronized (ServiceTxInterceptor.class) {
                popped = pop();
            }
            if (popped != invocation) {
                //something wrong....
                log.warn("invocation nest check, expected [" + invocation + "] but " + popped);
            }
        }
    }

    private static final Map thread2Stack = new HashMap();

    private static Stack getStack() {
        return (Stack) thread2Stack.get(Thread.currentThread());
    }

    private static void push(MethodInvocation invocation) {
        Stack stack = getStack();
        if (stack == null) {
            stack = new Stack();
            thread2Stack.put(Thread.currentThread(), stack);
        }
        stack.push(invocation);
    }

    private static MethodInvocation pop() {
        final Stack stack = getStack();
        if (stack == null) {
            //something wrong....
            return null;
        }
        return (MethodInvocation) stack.pop();
    }

    private static boolean isFirstInvocationInThread() {
        final Stack stack = getStack();
        if (stack == null)
            return true;
        return stack.isEmpty();
    }

    public Object invokeOnly(MethodInvocation invocation) throws Throwable {
        try {
            return invocation.proceed();
        } catch (Throwable t) {
            throw t;
        }
    }

    public Object invokeNewTx(MethodInvocation invocation) throws Throwable {
        final Transaction tx = hasTransaction() ? suspend() : null;
        Object ret = null;
        try {
            begin();
            try {
                ret = invocation.proceed();
                commit();
            } catch (Throwable t) {
                log.error("caught throwable, doing rollback... ", t);
                rollback();
                throw t;
            }
        } finally {
            if (tx != null)
                resume(tx);
        }
        return ret;
    }
}