/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/06/11 2:08:31
 */
package org.asyrinx.brownie.seasar.container.factory;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.TagAttributeNotDefinedRuntimeException;
import org.seasar.framework.xml.TagHandler;
import org.seasar.framework.xml.TagHandlerContext;
import org.xml.sax.Attributes;

/**
 * @author akima
 */
public class BrownieIncludeTagHandler extends TagHandler {

	/**
	 *  
	 */
	public BrownieIncludeTagHandler() {
		super();
	}

	/**
	 * @see org.seasar.framework.xml.sax.handler.TagHandler#start(org.seasar.framework.xml.sax.handler.TagHandlerContext,
	 *      org.xml.sax.Attributes)
	 */
	public void start(TagHandlerContext context, Attributes attributes) {
		final String path = attributes.getValue("path");
		if (path == null) {
			throw new TagAttributeNotDefinedRuntimeException("include", "path");
		}
		/*
		 * ςĂ܂B
		 */
		final S2Container child = BrownieS2ContainerFactory.create(path);
		final S2Container container = (S2Container) context.peek();
		container.include(child);
	}
}