/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/22 16:07:46
 */
package org.asyrinx.brownie.swing;

import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;

/**
 * @author akima
 */
public class AbsoluteConstraints implements Serializable {

	int x;

	int y;

	int width;

	int height;

	public AbsoluteConstraints(int i, int j) {
		width = -1;
		height = -1;
		x = i;
		y = j;
	}

	public AbsoluteConstraints(int i, int j, int k, int l) {
		width = -1;
		height = -1;
		x = i;
		y = j;
		width = k;
		height = l;
	}

	public AbsoluteConstraints(Point point) {
		this(point.x, point.y);
	}

	public AbsoluteConstraints(Point point, Dimension dimension) {
		width = -1;
		height = -1;
		x = point.x;
		y = point.y;
		if (dimension != null) {
			width = dimension.width;
			height = dimension.height;
		}
	}

	public String toString() {
		return super.toString() + " [x=" + x + ", y=" + y + ", width=" + width
				+ ", height=" + height + "]";
	}

	public int getHeight() {
		return height;
	}

	public int getWidth() {
		return width;
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	/**
	 * @param i
	 */
	public void setHeight(int i) {
		height = i;
	}

	/**
	 * @param i
	 */
	public void setWidth(int i) {
		width = i;
	}

	/**
	 * @param i
	 */
	public void setX(int i) {
		x = i;
	}

	/**
	 * @param i
	 */
	public void setY(int i) {
		y = i;
	}

}