/*
 * Created on 2004/05/27
 */
package org.asyrinx.brownie.swing.table;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import org.asyrinx.brownie.swing.table.util.InvisibleColumnTableModel;
import org.asyrinx.brownie.swing.table.util.SimpleSortableTableModel;

/**
 * @author akima
 */
public class ListViewTable extends JScrollPane {
	private javax.swing.JTable table = null;

	/**
	 *  
	 */
	public ListViewTable() {
		super();
		initialize();
		this.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		this
				.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
	}

	/**
	 * @param vsbPolicy
	 * @param hsbPolicy
	 */
	public ListViewTable(int vsbPolicy, int hsbPolicy) {
		super(vsbPolicy, hsbPolicy);
		initialize();
	}

	/**
	 * @param view
	 */
	public ListViewTable(Component view) {
		super(view);
		initialize();
		this.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		this
				.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
	}

	/**
	 * @param view
	 * @param vsbPolicy
	 * @param hsbPolicy
	 */
	public ListViewTable(Component view, int vsbPolicy, int hsbPolicy) {
		super(view, vsbPolicy, hsbPolicy);
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	protected void initialize() {
		this.setViewportView(getTable());
		this.setSize(252, 217);
	}

	private DefaultTableModel model = null;

	/**
	 * @return Returns the tableModel.
	 */
	public DefaultTableModel getModel() {
		return model;
	}

	private SimpleSortableTableModel sortableModel = null;

	public SimpleSortableTableModel getSortableModel() {
		return sortableModel;
	}

	private InvisibleColumnTableModel invisibleColumnModel = null;

	/**
	 * @return Returns the invisibleColumnModel.
	 */
	public InvisibleColumnTableModel getInvisibleColumnModel() {
		return invisibleColumnModel;
	}

	/**
	 * This method initializes jTable
	 * 
	 * @return javax.swing.JTable
	 */
	public javax.swing.JTable getTable() {
		if (table == null) {
			table = new javax.swing.JTable();
			initTable(table);
		}
		return table;
	}

	/**
	 *  
	 */
	protected void initTable(JTable target) {
		table.getTableHeader().addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				if (e.getButton() != MouseEvent.BUTTON1)
					return;
				final JTableHeader header = getTable().getTableHeader();
				final int viewColIndex = header.columnAtPoint(e.getPoint());
				final boolean reverse = (e.getClickCount() % 2) == 0;
				sortByViewColIndex(viewColIndex, reverse);
			}
		});
		//table.setBackground(new java.awt.Color(225, 225, 225));
		model = new DefaultTableModel();
		initColumns();
		model.setRowCount(0);
		//sortableModel̓IWĩf̃tB^ł
		sortableModel = TableUtils.toSortableModel(model);
		//invisibleColumnModel͔rIr[ɋ߂tB^Ȃ̂sortableModeľł
		invisibleColumnModel = TableUtils.toInvisibleColumnModel(sortableModel,
				getInvisibleColumnIndex(), getInvisibleColumnCount());
		target.setModel(TableUtils.toUneditableModel(invisibleColumnModel));
		target.setCellEditor(null);
		target.setEditingColumn(0);
		target.setColumnSelectionAllowed(false);
		target.setRowSelectionAllowed(true);
		target.setFocusable(true);
		target
				.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
		target.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
		initColumnWidth(target);
		//
		initRowData();
	}

	/**
	 * @param target
	 */
	protected void initRowData() {
		//do nothing
	}

	private void initColumnWidth(JTable target) {
		final int colCount = target.getTableHeader().getColumnModel()
				.getColumnCount();
		final TableColumnModel columnModel = target.getTableHeader()
				.getColumnModel();
		for (int i = 0; i < colCount; i++) {
			final TableColumn column = columnModel.getColumn(i);
			column.setPreferredWidth(getDefaultPreferredColumnWidth());
		}
	}

	private int defaultPreferredColumnWidth = 150;

	protected int getInvisibleColumnIndex() {
		return -1;
	}

	protected int getInvisibleColumnCount() {
		return 0;
	}

	protected void initColumns() {
		//do nothing
	}

	/**
	 * XN[ɕ\ẴCfbNXɃ\[gs܂
	 * 
	 * @param viewColIndex
	 */
	public void sortByViewColIndex(int viewColIndex, boolean reverse) {
		final int visibleModelColIndex = getTable().getTableHeader()
				.getColumnModel().getColumn(viewColIndex).getModelIndex();
		sortByVisibleModelColIndex(visibleModelColIndex, reverse);
	}

	/**
	 * tablẽf̃CfbNXɃ\[gs܂B getModelœ郂f̃CfbNXƂ͈قȂ邩܂B
	 * 
	 * @param viewColIndex
	 */
	public void sortByVisibleModelColIndex(int visibleModelColIndex,
			boolean reverse) {
		final int originalColIndex = getInvisibleColumnModel()
				.getOriginalColumnIndex(visibleModelColIndex);
		sortByOriginalModelColIndex(originalColIndex, reverse);
	}

	/**
	 * IWĩfiɋ߂sortableModelj\[g܂
	 * 
	 * @param originalColIndex
	 */
	public void sortByOriginalModelColIndex(int originalColIndex,
			boolean reverse) {
		getSortableModel().sort(originalColIndex, reverse);
		getTable().revalidate();
	}

	public void load(List entities) {
		//do nothing
	}

	/**
	 * @return
	 */
	public int getDefaultPreferredColumnWidth() {
		return defaultPreferredColumnWidth;
	}

	/**
	 * @param i
	 */
	public void setDefaultPreferredColumnWidth(int i) {
		defaultPreferredColumnWidth = i;
	}

} //  @jve:visual-info decl-index=0 visual-constraint="10,10"
