/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 13:43:38
 */
package org.asyrinx.brownie.swing.table.key;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import org.asyrinx.brownie.swing.table.util.UpdatableTableModel;

/**
 * @author akima
 */
public abstract class KeyColumnTableModel extends UpdatableTableModel implements RowKeyContainer {

    protected final TableModel tableModel;

    private final List keyList = new ArrayList();

    private final List keyColumns = new ArrayList();

    /**
     *  
     */
    public KeyColumnTableModel(TableModel tableModel) {
        super();
        this.tableModel = tableModel;
        //ŎsႤƔhNX̕ϐ̏sĂȂԂɂȂĂ܂̂ŃpX
        //initEventListener();
    }

    /**
     *  
     */
    public KeyColumnTableModel(TableModel tableModel, int[] keyColumns) {
        super();
        this.tableModel = tableModel;
        //ŎsႤƔhNX̕ϐ̏sĂȂԂɂȂĂ܂̂ŃpX
        //initKeyColumns(keyColumns);
        //refreshKeys();
        //initEventListener();
    }

    public void initKeyColumns(int[] keyCols) {
        beginUpdate();
        try {
            keyColumns.clear();
            for (int i = 0; i < keyCols.length; i++)
                addKeyColumn(keyCols[i]);
        } finally {
            endUpdate();
        }
    }

    public abstract void refreshKeys();

    protected KeyColumn findKeyColumn(int originalColumnIndex) {
        for (Iterator iter = keyColumns.iterator(); iter.hasNext();) {
            final KeyColumn keyColumn = (KeyColumn) iter.next();
            if (keyColumn.getOriginalColumnIndex() == originalColumnIndex)
                return keyColumn;
        }
        return null;
    }

    protected void initEventListener() {
        tableModel.addTableModelListener(new TableModelListener() {
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() == TableModelEvent.ALL_COLUMNS) {
                    refreshKeys();
                } else {
                    final KeyColumn keyColumn = findKeyColumn(e.getColumn());
                    if (keyColumn != null)
                        refreshKeys();
                }
                fireTableChanged(new TableModelEvent(KeyColumnTableModel.this, e.getFirstRow(), e.getLastRow(), e
                        .getColumn()));
            }
        });
    }

    public void addKeyColumn(int originalColumnIndex) {
        final KeyColumn keyColumn = new KeyColumn(originalColumnIndex, this.tableModel, this, keyColumns.size());
        addKeyColumn(keyColumn);
    }

    protected void addKeyColumn(KeyColumn keyColumn) {
        keyColumns.add(keyColumn);
        fireTableStructureChanged();
    }

    protected KeyColumn getKeyColumn(int index) {
        return (KeyColumn) keyColumns.get(index);
    }

    public int getKeyColumnCount() {
        return keyColumns.size();
    }

    public RowKey getKey(int rowIndex) {
        return (RowKey) keyList.get(rowIndex);
    }

    protected RowKey findKey(Object[] values) {
        final RowKey key = new RowKey(values);
        final int index = keyList.indexOf(key);
        return (index > -1) ? (RowKey) keyList.get(index) : null;
    }

    protected void clearKeyList() {
        keyList.clear();
    }

    protected void sortKeyList(Comparator comparator) {
        Collections.sort(keyList, comparator);
    }

    protected void addRowKey(RowKey rowKey) {
        keyList.add(rowKey);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.TableModel#getRowCount()
     */
    public int getRowCount() {
        return keyList.size();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.TableModel#isCellEditable(int, int)
     */
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.TableModel#setValueAt(java.lang.Object, int, int)
     */
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.TableModel#getColumnCount()
     */
    public int getColumnCount() {
        return tableModel.getColumnCount();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.AbstractTableModel#getColumnName(int)
     */
    public String getColumnName(int column) {
        return tableModel.getColumnName(column);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.table.AbstractTableModel#getColumnClass(int)
     */
    public Class getColumnClass(int columnIndex) {
        return tableModel.getColumnClass(columnIndex);
    }

}