/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/27 3:18:00
 */
package org.asyrinx.brownie.swing.table.wrapper;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/**
 * @author akima
 */
public class TableModelWrapper implements TableModel {

	/**
	 *  
	 */
	public TableModelWrapper(TableModel model) {
		super();
		this.model = model;
	}

	protected final TableModel model;

	/**
	 * @param l
	 */
	public void addTableModelListener(TableModelListener l) {
		model.addTableModelListener(l);
	}

	/**
	 * @param columnIndex
	 * @return
	 */
	public Class getColumnClass(int columnIndex) {
		return model.getColumnClass(columnIndex);
	}

	/**
	 * @return
	 */
	public int getColumnCount() {
		return model.getColumnCount();
	}

	/**
	 * @param columnIndex
	 * @return
	 */
	public String getColumnName(int columnIndex) {
		return model.getColumnName(columnIndex);
	}

	/**
	 * @return
	 */
	public int getRowCount() {
		return model.getRowCount();
	}

	/**
	 * @param rowIndex
	 * @param columnIndex
	 * @return
	 */
	public Object getValueAt(int rowIndex, int columnIndex) {
		return model.getValueAt(rowIndex, columnIndex);
	}

	/**
	 * @param rowIndex
	 * @param columnIndex
	 * @return
	 */
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return model.isCellEditable(rowIndex, columnIndex);
	}

	/**
	 * @param l
	 */
	public void removeTableModelListener(TableModelListener l) {
		model.removeTableModelListener(l);
	}

	/**
	 * @param aValue
	 * @param rowIndex
	 * @param columnIndex
	 */
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
		model.setValueAt(aValue, rowIndex, columnIndex);
	}

}