/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/20 21:08:24
 */
package org.asyrinx.brownie.tapestry.components.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.enum.Enum;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.form.PropertySelection;
import org.asyrinx.brownie.core.lang.MethodUtils;

/**
 * @author takeshi
 */
public abstract class EnumSelection extends PropertySelection {

    private IPropertySelectionModel model = null;

    public IPropertySelectionModel getModel() {
        if (this.model == null)
            this.model = buildModel();
        return this.model;
    }

    /**
     * @return
     */
    private IPropertySelectionModel buildModel() {
        final Object enums;
        try {
            enums = MethodUtils.invokeStaticMethod(getEnumClass(), getMethodName(), new Object[0]);
        } catch (Exception e) {
            throw new ApplicationRuntimeException("can't get Enum objects of " + getEnumClass());
        }
        final Enum[] enumArray = toArray(enums);
        return new SimpleEnumPropertySelectionModel(enumArray);
    }

    /**
     * @param enums
     * @return
     */
    private Enum[] toArray(Object enums) {
        if (enums instanceof Collection) {
            final Collection collection = (Collection) enums;
            return (Enum[]) collection.toArray(new Enum[0]);
        }
        if (enums.getClass().isAssignableFrom(Enum.class) && enums.getClass().isArray()) {
            return (Enum[]) enums;
        }
        if (enums instanceof Iterator) {
            final List result = new ArrayList();
            for (Iterator i = (Iterator) enums; i.hasNext();) {
                result.add(i.next());
            }
            return (Enum[]) result.toArray(new Enum[0]);
        }
        throw new ApplicationRuntimeException("unsupported object " + enums);
    }

    public abstract String getMethodName();

    public abstract Class getEnumClass();

}