/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/14 18:26:57
 */
package org.asyrinx.brownie.tapestry.components.form;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.Form;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.tapestry.util.BindingUtils;

/**
 * @author takeshi
 */
public abstract class Label extends AbstractComponent {

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding())
            return;
        final IFormComponent field = getField();
        final IForm form = Form.get(cycle);
        if (form == null) {
            String msg = Tapestry.getMessage("FieldLabel.must-be-contained-by-form");
            throw new ApplicationRuntimeException(msg, this, null, null);
        }
        final IValidationDelegate delegate = form.getDelegate();
        if (delegate == null) {
            String msg = Tapestry.format("FieldLabel.no-delegate", getExtendedId(), form
                    .getExtendedId());
            throw new ApplicationRuntimeException(msg, this, null, null);
        }
        delegate.writeLabelPrefix(field, writer, cycle);
        if (this.getBodyCount() > 0) {
            renderBody(writer, cycle);
        } else {
            final String displayName = getDisplayName(field);
            if (!StringUtils.isEmpty(displayName)) {
                if (getRaw()) {
                    writer.printRaw(displayName);
                } else {
                    writer.print(displayName);
                }
            }
        }
        delegate.writeLabelSuffix(field, writer, cycle);
    }

    /**
     * @param field
     * @return
     */
    private String getDisplayName(IFormComponent field) {
        String displayName = getDisplayName();
        if (displayName != null)
            return displayName;
        if (field == null)
            throw Tapestry.createRequiredParameterException(this, "field");
        displayName = field.getDisplayName();
        if (displayName != null)
            return displayName;
        displayName = BindingUtils.getInformalParameter(field, "displayName");
        if (displayName != null)
            return displayName;
        return null;
    }

    public abstract String getDisplayName();

    public abstract IFormComponent getField();

    public abstract boolean getRaw();

}