/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/08
 */
package org.asyrinx.brownie.tapestry.components.layer;

import java.util.Map;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;

/**
 * @author akima
 */
public abstract class Popup extends BaseDesktopComponent {

	/**
	 * @param scriptName
	 */
	public Popup() {
		super("Popup.script");
		this.setWidth("300");
		this.setHeight(null);
	}

	/**
	 * @see org.apache.tapestry.AbstractComponent#finishLoad()
	 */
	protected void finishLoad() {
		this.setPopdownImage(getAsset("img_popdown"));
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.script.AbstractScriptComponent#prepareScriptSymbols(java.util.Map,
	 *      org.apache.tapestry.IRequestCycle)
	 */
	public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
		super.prepareScriptSymbols(symbols, cycle);
		symbols.put("link_id", getLinkId());
		symbols.put("frame", new Integer(getFrame()));
		symbols.put("interval", new Integer(getInterval()));
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.script.AbstractScriptComponent#renderComponent(org.apache.tapestry.IMarkupWriter,
	 *      org.apache.tapestry.IRequestCycle)
	 */
	protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
		checkBeforeRender(writer, cycle);
		this.scriptWriter.execute(cycle);

		writer.begin("div");
		writer.attribute("id", getStyleId());
		writer.attribute("style", "VISIBILITY:hidden; " + toStyleValue());
		renderInformalParameters(writer, cycle);
		writer.println();
		super.renderComponent(writer, cycle);
		writer.end();
	}

	/**
	 * {.script̕ŉH񂾂ǁEEEEE 炵̂ł傤ȂȊɁB
	 * 
	 * @return
	 */
	public String getInvokePopdown() {
		return "popdown_btn_" + getStyleId() + "_click()";
	}

	abstract public String getLinkId();

	abstract public void setLinkId(String string);

	private int frame = 10; //

	private int interval = 20; // mili-second

	private int cellSpacing = 0;

	private int cellPadding = 0;

	private int border = 0;

	private IAsset popdownImage = null;

	/**
	 * @return
	 */
	public int getFrame() {
		return frame;
	}

	/**
	 * @return
	 */
	public int getInterval() {
		return interval;
	}

	/**
	 * @param i
	 */
	public void setFrame(int i) {
		frame = i;
	}

	/**
	 * @param i
	 */
	public void setInterval(int i) {
		interval = i;
	}

	/**
	 * @return
	 */
	public int getBorder() {
		return border;
	}

	/**
	 * @return
	 */
	public int getCellPadding() {
		return cellPadding;
	}

	/**
	 * @return
	 */
	public int getCellSpacing() {
		return cellSpacing;
	}

	/**
	 * @return
	 */
	public IAsset getPopdownImage() {
		return popdownImage;
	}

	/**
	 * @param i
	 */
	public void setBorder(int i) {
		border = i;
	}

	/**
	 * @param i
	 */
	public void setCellPadding(int i) {
		cellPadding = i;
	}

	/**
	 * @param i
	 */
	public void setCellSpacing(int i) {
		cellSpacing = i;
	}

	/**
	 * @param asset
	 */
	public void setPopdownImage(IAsset asset) {
		popdownImage = asset;
	}

}