/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/07
 */
package org.asyrinx.brownie.tapestry.components.layer;

import java.util.Map;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.tapestry.script.IScriptUser;
import org.asyrinx.brownie.tapestry.script.ScriptUsage;
import org.asyrinx.brownie.tapestry.script.ScriptWriter;

/**
 * @author akima
 */
public abstract class TipsLink extends AbstractComponent implements IScriptUser {

	/**
	 * @param scriptName
	 */
	public TipsLink() {
		super();
		this.writer = new ScriptWriter(this, "TipsLink.script");
		this.writer.setUsage(ScriptUsage.ONCE_BY_CLASS);
	}

	private final ScriptWriter writer;

	private int x = 0;

	private int y = 10;

	private String position = "center";

	private String tipsId = null;

	/**
	 * @see org.apache.tapestry.AbstractComponent#renderComponent(org.apache.tapestry.IMarkupWriter,
	 *      org.apache.tapestry.IRequestCycle)
	 */
	protected void renderComponent(IMarkupWriter markupWriter, IRequestCycle cycle) {
		this.writer.execute(cycle);

		markupWriter.begin("a");
		markupWriter.attribute("style", "TEXT-DECORATION:none");
		markupWriter.attribute("href", "javascript:void(0);");
		markupWriter.attribute("onclick", "return false;");
		markupWriter.attribute("onmouseover", "showTips('" + tipsId + "',event," + x
				+ "," + y + ",'" + position + "');");
		markupWriter.attribute("onmouseout", "hideTips('" + tipsId + "');");
		renderBody(markupWriter, cycle);
		markupWriter.end();
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.script.AbstractScriptComponent#prepareScriptSymbols(java.util.Map,
	 *      org.apache.tapestry.IRequestCycle)
	 */
	public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
		//no symbols
	}

	/**
	 * @return
	 */
	public String getPosition() {
		return position;
	}

	/**
	 * @return
	 */
	public int getX() {
		return x;
	}

	/**
	 * @return
	 */
	public int getY() {
		return y;
	}

	/**
	 * @param string
	 */
	public void setPosition(String string) {
		position = string;
	}

	/**
	 * @param i
	 */
	public void setX(int i) {
		x = i;
	}

	/**
	 * @param i
	 */
	public void setY(int i) {
		y = i;
	}

	/**
	 * @return
	 */
	public String getTipsId() {
		return tipsId;
	}

	/**
	 * @param string
	 */
	public void setTipsId(String string) {
		tipsId = string;
	}

}