/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/04
 */
package org.asyrinx.brownie.tapestry.components.link;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.link.ILinkRenderer;
import org.asyrinx.brownie.tapestry.script.ScriptUtils;

/**
 * @author akima
 */
public abstract class AbstractScriptLinkRenderer implements ILinkRenderer {

	/**
	 *  
	 */
	public AbstractScriptLinkRenderer(String scriptName) {
		super();
		this.scriptName = scriptName;
	}

	private final String scriptName;

	private IScript script = null;

	/**
	 * @return
	 */
	protected IScript loadScript(ILinkComponent linkComponent) {
		if (script == null)
			script = ScriptUtils.loadScript(linkComponent, getScriptName());
		return script;
	}

	/**
	 * @return
	 */
	protected String getScriptName() {
		return scriptName;
	}

	/**
	 * @see org.apache.tapestry.link.ILinkRenderer#renderLink(org.apache.tapestry.IMarkupWriter,
	 *      org.apache.tapestry.IRequestCycle,
	 *      org.apache.tapestry.components.ILinkComponent)
	 */
	public void renderLink(IMarkupWriter writer, IRequestCycle cycle,
			ILinkComponent linkComponent) {
		// check valid cycle( including body ) and valid linkComponent
		checkBeforeRender(cycle, linkComponent);
		cycle.setAttribute(Tapestry.LINK_COMPONENT_ATTRIBUTE_NAME,
				linkComponent);
		try {
			final IScript loadedScript = loadScript(linkComponent);
			final boolean hasBody = getHasBody();
			final boolean disabled = linkComponent.isDisabled();
			// template method to add script
			if (!cycle.isRewinding()) {
				final Body body = Body.get(cycle);
				if (!disabled) {
					addScript(cycle, loadedScript, body);
				}
				// template method to render begin tag
				renderBeginTag(writer, cycle, linkComponent);
			}
			//beforeBodyRender(writer, cycle, linkComponent);
			final IMarkupWriter wrappedWriter = (!disabled) ? writer
					.getNestedWriter() : writer;
			if (hasBody) {
				// template method to render tag bodies
				renderBody(wrappedWriter, cycle, linkComponent);
				linkComponent.renderBody(wrappedWriter, cycle);
			}
			if (!cycle.isRewinding()) {
				//afterBodyRender(writer, cycle, linkComponent);
				linkComponent.renderAdditionalAttributes(writer, cycle);
				if (hasBody) {
					wrappedWriter.close();
					// Close the <element> tag
					writer.end();
				} else
					writer.closeTag();
			}

		} finally {
			cycle.removeAttribute(Tapestry.LINK_COMPONENT_ATTRIBUTE_NAME);
		}
	}

	protected void checkBeforeRender(IRequestCycle cycle,
			ILinkComponent linkComponent) {
		if (cycle.getAttribute(Tapestry.LINK_COMPONENT_ATTRIBUTE_NAME) != null)
			throw new ApplicationRuntimeException(Tapestry
					.getMessage("AbstractLinkComponent.no-nesting"),
					linkComponent, null, null);
		if (!cycle.isRewinding()) {
			final Body body = Body.get(cycle);
			if (body == null)
				throw new ApplicationRuntimeException(
						"must-be-contained-by-body", this, null, null);
		}
	}

	/**
	 * Converts the EngineServiceLink into a URI or URL. This implementation
	 * simply invokes {@link ILink#getURL(String, boolean)}.
	 *  
	 */
	protected final String constructURL(ILink link, String anchor) {
		return link.getURL(anchor, true);
	}

	protected boolean getHasBody() {
		return true;
	}

	abstract protected void addScript(IRequestCycle cycle, IScript addingScript,
			Body body);

	/**
	 * @param writer
	 * @param cycle
	 * @param linkComponent
	 */
	abstract protected void renderBeginTag(IMarkupWriter writer,
			IRequestCycle cycle, ILinkComponent linkComponent);

	/**
	 * @param writer
	 * @param cycle
	 * @param linkComponent
	 */
	abstract protected void renderBody(IMarkupWriter writer,
			IRequestCycle cycle, ILinkComponent linkComponent);

}