/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/26 12:27:37
 */
package org.asyrinx.brownie.tapestry.components.util;

import java.text.Format;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author takeshi
 */
public abstract class Insert extends AbstractComponent {
    public abstract IBinding getFormatBinding();

    /**
     * Prints its value parameter, possibly formatted by its format parameter.
     *  
     */

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding())
            return;
        final Object value = getValue();
        if (value == null)
            return;
        final String insert = buildInsertValue(value);
        final String styleClass = getStyleClass();
        if (styleClass != null) {
            writer.begin("span");
            writer.attribute("class", styleClass);
            renderInformalParameters(writer, cycle);
        }
        if (getRaw())
            writer.printRaw(insert);
        else
            writer.print(insert);
        if (styleClass != null)
            writer.end(); // <span>
    }

    /**
     * @param value
     * @return
     */
    private String buildInsertValue(final Object value) {
        final String result;
        final Format format = getFormat();
        if (format == null) {
            result = value.toString();
        } else {
            try {
                result = format.format(value);
            } catch (Exception ex) {
                throw new ApplicationRuntimeException(Tapestry.format("Insert.unable-to-format",
                        value), this, getFormatBinding().getLocation(), ex);
            }
        }
        return abbreviate(result);
    }

    /**
     * @param value
     * @return
     */
    private String abbreviate(String value) {
        if (value == null)
            return null;
        if (getMaxlength() < 1)
            return value;
        //StringUtils.abbreviate̎dlmaxlength4ȏザȂƂ߁B
        if (getMaxlength() > 3)
            return StringUtils.abbreviate(value, getMaxlength());
        else {
            if (value.length() > getMaxlength())
                return value.substring(0, getMaxlength());
            else
                return value;
        }
    }

    public abstract Object getValue();

    public abstract Format getFormat();

    public abstract String getStyleClass();

    public abstract boolean getRaw();

    public abstract int getMaxlength();
}