/*
 * brownie-tapestry-sample and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/15 5:56:39
 */
package org.asyrinx.brownie.tapestry.components.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;

/**
 * @author takeshi
 */
public abstract class InsertBean extends AbstractComponent {

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.tapestry.AbstractComponent#renderComponent(org.apache.tapestry.IMarkupWriter,
     *      org.apache.tapestry.IRequestCycle)
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding())
            return;
        final Object bean = getBean();
        if (bean == null)
            return;
        final Map map = getPropertyMap();
        if (bean == null)
            return;
        final String styleClass = getStyleClass();
        if (styleClass != null)
            map.put("class", styleClass);
        final String element = getElement();
        if (!StringUtils.isEmpty(element)) {
            writer.begin(element);
            renderAttributes(writer, map, tagAttrRenderer);
            renderInformalParameters(writer, cycle);
            //
            final IMarkupWriter nested = writer.getNestedWriter();
            renderBody(nested, cycle);
            nested.close();
            //
            writer.end(element); // </...>
        } else {
            renderAttributes(writer, map, asTextRenderer);
        }
    }

    /**
     * @return
     */
    private Map getPropertyMap() {
        final Collection propNames = toCollection(getProperties(), "properties");
        final Map result;
        if ((propNames == null) || propNames.isEmpty())
            result = getPropertyMapByDesc();
        else
            result = getPropertyMapByEach();
        deleteIgnoreProp(result);
        return result;
    }

    private Map getPropertyMapByDesc() {
        final Map result;
        try {
            result = PropertyUtils.describe(getBean());
        } catch (Exception e) {
            if (isStrict())
                throw new ApplicationRuntimeException(e);
            else
                return new HashMap();
        }
        return result;
    }

    private Map getPropertyMapByEach() {
        final Map result = new HashMap();
        final Object bean = getBean();
        final Collection propNames = toCollection(getProperties(), "properties");
        for (Iterator i = propNames.iterator(); i.hasNext();) {
            final Object key = i.next();
            if (key == null)
                continue;
            final String propName = String.valueOf(key);
            try {
                final Object value = PropertyUtils.getProperty(bean, propName);
                result.put(propName, value);
            } catch (Exception e) {
                if (isStrict())
                    throw new ApplicationRuntimeException(e);
            }
        }
        return result;
    }

    /**
     * @param result
     */
    private void deleteIgnoreProp(Map result) {
        result.remove("class");
        final Collection ignorePropNames = toCollection(getIgnoreProperties(), "ignoreProperties");
        if ((ignorePropNames == null) || ignorePropNames.isEmpty())
            return;
        for (Iterator i = ignorePropNames.iterator(); i.hasNext();)
            result.remove(i.next());
    }

    /**
     * @param writer
     * @param map
     */
    private void renderAttributes(IMarkupWriter writer, Map map, LocalRenderer renderer) {
        for (Iterator i = map.entrySet().iterator(); i.hasNext();) {
            final Map.Entry entry = (Map.Entry) i.next();
            final String key = String.valueOf(entry.getKey());
            final Object value = entry.getValue();
            if (value == null)
                continue;
            if (StringUtils.isEmpty(value.toString()))
                continue;
            renderer.render(writer, key, value.toString());
        }
    }

    protected Collection toCollection(Object object, String propName) {
        if (object == null)
            return null;
        if (object instanceof Collection) {
            return (Collection) object;
        } else if (object.getClass().isArray()) {
            return org.asyrinx.brownie.core.lang.ArrayUtils.toArrayList((Object[]) object);
        } else {
            throw new ApplicationRuntimeException(propName + "was neither Collection nor Object[]");
        }

    }

    interface LocalRenderer {
        void render(IMarkupWriter writer, String key, String value);
    }

    private final LocalRenderer tagAttrRenderer = new LocalRenderer() {
        public void render(IMarkupWriter writer, String key, String value) {
            writer.attribute(key, value);
        }
    };

    private final LocalRenderer asTextRenderer = new LocalRenderer() {
        public void render(IMarkupWriter writer, String key, String value) {
            writer.print(' ');
            writer.print(key);
            writer.print("=\"");
            writer.print(value);
            writer.print('"');
        }
    };

    public abstract Object getBean();

    public abstract String getElement();

    public abstract String getStyleClass();

    public abstract Object getProperties();

    public abstract Object getIgnoreProperties();

    public abstract boolean isStrict();
}