/*
 * brownie-tapestry-sample and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/07 4:37:27
 */
package org.asyrinx.brownie.tapestry.components.util;

import java.util.Iterator;
import java.util.Map;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;

/**
 * @author takeshi
 */
public abstract class SpanMap extends AbstractComponent {

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding())
            return;
        for (Iterator i = getSource().entrySet().iterator(); i.hasNext();) {
            final Map.Entry entry = (Map.Entry) i.next();
            writer.begin(getElement());
            writer.attribute("id", getSpanId());
            writer.attribute("title", String.valueOf(entry.getKey()));
            if (!isVisible())
                writer.attribute("style", "display:none");
            if (entry.getValue() != null)
                writer.print(String.valueOf(entry.getValue()));
            writer.end();
            writer.println();
        }
    }

    abstract public String getElement();

    abstract public String getSpanId();

    abstract public boolean isVisible();

    abstract public Map getSource();

}