/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/17 18:49:10
 */
package org.asyrinx.brownie.tapestry.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author takeshi
 */
public class BindingUtils {

    private static final Log log = LogFactory.getLog(BindingUtils.class);

    public static void renderInformalParametersFilteredTail(IComponent component,
            IMarkupWriter writer, IRequestCycle cycle, String tail) {
        final Map filteredParams = getInformalParameters(component, cycle, new TailFilter(tail));
        log.debug("renderInformalParametersFilteredTail tail=" + tail + "  filteredParams = "
                + filteredParams);
        renderParameters(writer, filteredParams);
    }

    public static void renderInformalParameters(IComponent component, IMarkupWriter writer,
            IRequestCycle cycle) {
        final Map filteredParams = getInformalParameters(component, cycle, ALL);
        renderParameters(writer, filteredParams);
    }

    private static void renderParameters(IMarkupWriter writer, Map parameters) {
        for (Iterator i = parameters.entrySet().iterator(); i.hasNext();) {
            final Map.Entry entry = (Map.Entry) i.next();
            final String name = String.valueOf(entry.getKey());
            final String attribute = String.valueOf(entry.getValue());
            writer.attribute(name, attribute);
        }
    }

    public static Map getComponentParameters(IComponent component, IRequestCycle cycle) {
        return getInformalParameters(component, cycle, ALL);
    }

    public static String getInformalParameter(IComponent component, String parameterName) {
        final IBinding value = component.getBinding(parameterName);
        return (value == null) ? null : value.getString();
    }

    public static Map getInformalParameters(IComponent component, IRequestCycle cycle,
            ComponentParameterFilter filter) {
        if (component.getBindings() == null)
            return Collections.EMPTY_MAP;
        final Map result = new HashMap();
        final Iterator i = component.getBindings().entrySet().iterator();
        while (i.hasNext()) {
            final Map.Entry entry = (Map.Entry) i.next();
            final String name = (String) entry.getKey();
            final IBinding binding = (IBinding) entry.getValue();
            final Object value = binding.getObject();
            if (value == null)
                continue;
            final String attribute;
            if (value instanceof IAsset) {
                IAsset asset = (IAsset) value;
                attribute = asset.buildURL(cycle);
            } else
                attribute = value.toString();
            if (filter.filter(component, cycle, name, attribute)) {
                filter.put(component, cycle, result, name, attribute);
            }
        }
        return result;
    }

    interface ComponentParameterFilter {
        boolean filter(IComponent component, IRequestCycle cycle, String name, String attribute);

        void put(IComponent component, IRequestCycle cycle, Map dest, String name, String attribute);
    }

    public static final ComponentParameterFilter ALL = new ComponentParameterFilter() {
        public boolean filter(IComponent component, IRequestCycle cycle, String name,
                String attribute) {
            return true;
        }

        public void put(IComponent component, IRequestCycle cycle, Map dest, String name,
                String attribute) {
            dest.put(name, attribute);
        }
    };

    public static class TailFilter implements ComponentParameterFilter {
        public TailFilter(String tail) {
            super();
            this.tail = tail;
        }

        protected final String tail;

        public boolean filter(IComponent component, IRequestCycle cycle, String name,
                String attribute) {
            return name.endsWith(tail);
        }

        public void put(IComponent component, IRequestCycle cycle, Map dest, String name,
                String attribute) {
            final String key = StringUtils.left(name, name.length() - tail.length());
            dest.put(key, attribute);
        }
    }

}