/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/14 9:59:41
 */
package org.asyrinx.brownie.tapestry.valid;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.binding.StaticBinding;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.ValidationDelegate;
import org.asyrinx.brownie.tapestry.util.BindingUtils;

/**
 * @author takeshi
 */
public class BrownieValidationDelegate extends ValidationDelegate {

    /**
     *  
     */
    public BrownieValidationDelegate() {
        super();
    }

    public void writeLabelPrefix(IFormComponent component, IMarkupWriter writer, IRequestCycle cycle) {
        String id = BindingUtils.getInformalParameter(component, "id");
        if (id == null)
            id = buildId(component, cycle);
        writer.begin("label");
        writer.attribute("for", id);
        super.writeLabelPrefix(component, writer, cycle);
    }

    /**
     * @param component
     * @return
     */
    private String buildId(IFormComponent component, IRequestCycle cycle) {
        //final IForm form = Form.get(cycle);
        //final String id = form.getElementId(component);
        final String id = component.getId();
        component.setBinding("id", new StaticBinding(id, component.getLocation()));
        return id;
    }

    public void writeLabelSuffix(IFormComponent component, IMarkupWriter writer, IRequestCycle cycle) {
        super.writeLabelSuffix(component, writer, cycle);
        final String id = BindingUtils.getInformalParameter(component, "id");
        if (id == null)
            return;
        writer.end("label");
    }

}