package org.asyrinx.brownie.validator;

import org.apache.commons.lang.enum.ValuedEnum;

/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/04 17:21:15
 */

/**
 * @author takeshi
 */
public final class MessageLevel extends ValuedEnum {

    /**
     * @param name
     */
    private MessageLevel(int value, String name) {
        super(name, value);
    }

    public static final MessageLevel DEBUG = new MessageLevel(1, "debug");

    public static final MessageLevel INFO = new MessageLevel(2, "info");

    public static final MessageLevel WARN = new MessageLevel(3, "warn");

    public static final MessageLevel ERROR = new MessageLevel(4, "error");

    public static final MessageLevel FATAL = new MessageLevel(5, "fatal");

    /**
     * @param level
     * @return
     */
    public boolean isGreaterEqual(MessageLevel level) {
        return this.getValue() >= level.getValue();
    }

}