/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/04 20:49:39
 */
package org.asyrinx.brownie.validator.prop;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.ValidatorRuntimeException;

/**
 * @author takeshi
 */
public abstract class AbstractPropertyValidator implements PropertyValidator {

    /**
     *  
     */
    public AbstractPropertyValidator(String propertyName, String displayName) {
        super();
        this.propertyName = propertyName;
        this.displayName = displayName;
    }

    public Class getPropertyClass() {
        return String.class;
    }

    public abstract void evaluate(ValidationContext context, Object obj, Object propertyValue);

    protected final String propertyName;

    protected final String displayName;

    public String getPropertyName() {
        return propertyName;
    }

    public String getDisplayName() {
        return displayName;
    }

    protected String getMessageKey() {
        return this.getClass().getName();
    }

    public void evaluate(ValidationContext context, Object obj) {
        final Object propertyValue;
        try {
            propertyValue = PropertyUtils.getProperty(obj, this.propertyName);
        } catch (Exception e) {
            throw new ValidatorRuntimeException(e);
        }
        if ((propertyValue != null) && (!getPropertyClass().isInstance(propertyValue)))
            throw new ValidatorRuntimeException("propertyValue isn't a intance of "
                    + getPropertyClass().getName());
        evaluate(context, obj, propertyValue);
    }

    /**
     * @param obj
     * @return
     */
    protected String getPropertyAsString(Object obj) {
        try {
            return BeanUtils.getProperty(obj, this.propertyName);
        } catch (Exception e) {
            throw new ValidatorRuntimeException(e);
        }
    }

    /**
     * @param obj
     * @return
     */
    protected Object getPropertyAsObject(Object obj) {
        try {
            return PropertyUtils.getProperty(obj, this.propertyName);
        } catch (Exception e) {
            throw new ValidatorRuntimeException(e);
        }
    }

    protected void addError(ValidationContext context) {
        final Map parameters = new HashMap(3);
        prepareParameters(parameters);
        final Message message = context.addError(this.getMessageKey(), parameters);
        message.addProperty(this.getPropertyName());
    }

    /**
     * @param parameters
     */
    protected void prepareParameters(Map parameters) {
        parameters.put("displayName", getDisplayName());
    }

}