/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/10 12:22:05
 */
package org.asyrinx.brownie.validator.prop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.validator.ValidationContext;

/**
 * @author takeshi
 */
public abstract class AbstractStringField extends AbstractPropertyValidator {

    public AbstractStringField(String propertyName, String displayName, boolean required,
            int maxLength) {
        super(propertyName, displayName);
        this.required = required;
        this.maxLength = maxLength;
        if (required)
            addValidator(new Required(propertyName, displayName));
        if (maxLength > 0)
            addValidator(new MaxByteLength(propertyName, displayName, maxLength));
    }

    private final List validators = new ArrayList(5);

    public List getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public final void addValidator(PropertyValidator validator) {
        if (validator == null)
            return;
        this.validators.add(validator);
    }

    public void evaluate(ValidationContext context, Object obj, Object propertyValue) {
        if (!this.prepared) {
            prepareValidators();
            this.prepared = true;
        }
        for (Iterator i = this.validators.iterator(); i.hasNext();) {
            final PropertyValidator validator = (PropertyValidator) i.next();
            validator.evaluate(context, obj, propertyValue);
        }
    }

    private boolean prepared = false;

    protected void prepareValidators() {
        if (!StringUtils.isEmpty(getRegExp()))
            addValidator(new RegExp(propertyName, displayName, getRegExp()));
    }

    private String regExp;

    public String getRegExp() {
        return regExp;
    }

    public void setRegExp(String regExp) {
        this.regExp = regExp;
    }

    private final boolean required;

    public boolean isRequired() {
        return required;
    }

    private int maxLength = 0;

    public int getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}