/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 16:07:43
 */
package org.asyrinx.brownie.validator.prop;

import java.util.Map;

import org.asyrinx.brownie.core.chars.Characters;
import org.asyrinx.brownie.validator.ValidationContext;

/**
 * @author takeshi
 */
public class AcceptableCharacters extends AbstractPropertyValidator {

    /**
     * @param propertyName
     */
    public AcceptableCharacters(String propertyName, String displayName, Characters characterSet) {
        this(propertyName, displayName, characterSet, false);
    }

    public void evaluate(ValidationContext context, Object obj, Object propertyValue) {
        if (!checkAcceptable((String) propertyValue))
            this.addError(context);
    }

    /**
     * @param propertyName
     */
    public AcceptableCharacters(String propertyName, String displayName, Characters characterSet,
            boolean refuse) {
        super(propertyName, displayName);
        this.characterSet = characterSet;
        this.refuse = refuse;
    }

    private final Characters characterSet;

    private final boolean refuse;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.validator.prop.AbstractPropertyValidator#getMessageKey()
     */
    protected String getMessageKey() {
        return super.getMessageKey() + ((this.refuse ? ".refuse" : ".accept"));
    }

    protected void prepareParameters(Map parameters) {
        super.prepareParameters(parameters);
        parameters.put("acceptable", getCharacters().getName());
    }

    /**
     * @param propValue
     * @return
     */
    private boolean checkAcceptable(String propValue) {
        if (propValue == null)
            return true;
        for (int i = 0; i < propValue.length(); i++) {
            if (!checkAcceptable(propValue.charAt(i)))
                return false;
        }
        return true;
    }

    private boolean checkAcceptable(char c) {
        if (this.refuse) {
            if (this.characterSet.contains(c))
                return false;
        } else {
            if (!this.characterSet.contains(c))
                return false;
        }
        return true;
    }

    public Characters getCharacters() {
        return characterSet;
    }

    public boolean isRefuse() {
        return refuse;
    }
}