/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/10 11:48:39
 */
package org.asyrinx.brownie.validator.prop;

import org.asyrinx.brownie.core.chars.CharactersExpressionParser;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author takeshi
 */
public class StringFieldCharsExp extends AbstractStringField {

    /**
     * @param propertyName
     * @param displayName
     * @param required
     * @param size
     */
    public StringFieldCharsExp(String propertyName, String displayName, boolean required, int size) {
        super(propertyName, displayName, required, size);
    }

    protected void prepareValidators() {
        addValidator(getAcceptedValidator());
        addValidator(getRefusedValidator());
    }

    /**
     * @param exp
     * @param refused
     * @return
     */
    private AcceptableCharacters createAcceptable(String exp, boolean refused) {
        if (StringUtils.isEmpty(exp))
            return null;
        return new AcceptableCharacters(this.getPropertyName(), this.getDisplayName(),
                characterSetExpressionParser.parseToComposite(exp), refused);
    }

    private AcceptableCharacters acceptedValidator = null;

    private AcceptableCharacters refusedValidator = null;

    public AcceptableCharacters getAcceptedValidator() {
        if (this.acceptedValidator == null)
            this.acceptedValidator = createAcceptable(this.getAccepted(), false);
        return this.acceptedValidator;
    }

    public AcceptableCharacters getRefusedValidator() {
        if (this.refusedValidator == null)
            this.refusedValidator = createAcceptable(this.getRefused(), true);
        return this.refusedValidator;
    }

    private String accepted = null;

    private String refused = null;

    public String getAccepted() {
        return accepted;
    }

    public void setAccepted(String accepted) {
        this.accepted = accepted;
    }

    public String getRefused() {
        return refused;
    }

    public void setRefused(String refused) {
        this.refused = refused;
    }

    private CharactersExpressionParser characterSetExpressionParser = null;

    public CharactersExpressionParser getCharacterSetExpressionParser() {
        return characterSetExpressionParser;
    }

    public void setCharacterSetExpressionParser(
            CharactersExpressionParser characterSetExpressionParser) {
        this.characterSetExpressionParser = characterSetExpressionParser;
    }
}