/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 15:58:33
 */
package org.asyrinx.brownie.validator.prop;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.chars.Characters;
import org.asyrinx.brownie.core.chars.impl.AbstractCompositeCharacters;
import org.asyrinx.brownie.core.chars.impl.CompositeCharacters;
import org.asyrinx.brownie.core.chars.impl.StringCharacters;

/**
 * @author takeshi
 */
public class StringFieldToAddChars extends AbstractStringField {

    /**
     * @param propertyName
     * @param displayName
     * @param required
     * @param size
     */
    public StringFieldToAddChars(String propertyName, String displayName, boolean required, int size) {
        super(propertyName, displayName, required, size);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.validator.prop.AbstractStringField#prepareValidators()
     */
    protected void prepareValidators() {
        if (acceptedChar != null)
            addValidator(new AcceptableCharacters(getPropertyName(), getDisplayName(),
                    this.acceptedChar));
        if (refusedChar != null)
            addValidator(new AcceptableCharacters(getPropertyName(), getDisplayName(),
                    this.refusedChar, true));
    }

    private StringFieldCharacterSet acceptedChar = null;

    private StringFieldCharacterSet refusedChar = null;

    public void addAcceptable(String value) {
        addAcceptable(new StringCharacters(value, value));
    }

    public void addAcceptable(Characters value) {
        if (acceptedChar == null)
            acceptedChar = new StringFieldCharacterSet();
        acceptedChar.add(value);
    }

    public void addRefused(String value) {
        addRefused(new StringCharacters(value, value));
    }

    public void addRefused(Characters value) {
        if (refusedChar == null)
            refusedChar = new StringFieldCharacterSet();
        refusedChar.add(value);
    }
}

class StringFieldCharacterSet extends AbstractCompositeCharacters {

    public StringFieldCharacterSet() {
        super("");
    }

    private final List components = new ArrayList(3);

    public String getName() {
        return CompositeCharacters.buildName(components.iterator());
    }

    protected Iterator componentIterator() {
        return components.iterator();
    }

    public void add(Characters characterSet) {
        this.components.add(characterSet);
    }
}