/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/05 17:20:43
 */
package test.java.lang;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class ClassTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ClassTest.class);
    }

    public static interface IA {
    }

    public static interface IB extends IA {
    }

    public static interface IC extends IB {
    }

    public static interface ID extends IB {
    }

    public static interface IE {
    }

    public static interface IF extends IA {
    }

    public static interface IG extends IE {
    }

    public static interface IH extends IE, IB {
    }

    public static class CA {
    }

    public static class CB extends CA {
    }

    public static class CC extends CB {
    }

    public static class CD extends CB implements IC {
    }

    public static class CE extends CB implements IE {
    }

    public static class CF extends CC implements IE, IB {
    }

    public static class CG extends CA implements IC {
    }

    public static class CH extends CA implements IE {
    }

    public static class CI extends CA implements IE, IB {
    }

    public static class CA2 extends CA {
    }

    public static class CB2 extends CB {
    }

    public static class CC2 extends CC {
    }

    public static class CD2 extends CD {
    }

    public static class CE2 extends CE {
    }

    public static class CF2 extends CF {
    }

    public static class CG2 extends CG {
    }

    public static class CH2 extends CH {
    }

    public static class CI2 extends CI {
    }

    public void testSuperclass() {
        assertEquals(null, IA.class.getSuperclass());
        assertEquals(null, IB.class.getSuperclass());
        assertEquals(null, IC.class.getSuperclass());
        assertEquals(null, ID.class.getSuperclass());
        assertEquals(null, IE.class.getSuperclass());
        assertEquals(null, IF.class.getSuperclass());
        assertEquals(null, IG.class.getSuperclass());
        assertEquals(null, IH.class.getSuperclass());
        assertEquals(Object.class, CA.class.getSuperclass());
        assertEquals(CA.class, CB.class.getSuperclass());
        assertEquals(CB.class, CC.class.getSuperclass());
        assertEquals(CB.class, CD.class.getSuperclass());
        assertEquals(CB.class, CE.class.getSuperclass());
        assertEquals(CC.class, CF.class.getSuperclass());
        assertEquals(CA.class, CG.class.getSuperclass());
        assertEquals(CA.class, CH.class.getSuperclass());
        assertEquals(CA.class, CI.class.getSuperclass());
        assertEquals(CA.class, CA2.class.getSuperclass());
        assertEquals(CB.class, CB2.class.getSuperclass());
        assertEquals(CC.class, CC2.class.getSuperclass());
        assertEquals(CD.class, CD2.class.getSuperclass());
        assertEquals(CE.class, CE2.class.getSuperclass());
        assertEquals(CF.class, CF2.class.getSuperclass());
        assertEquals(CG.class, CG2.class.getSuperclass());
        assertEquals(CH.class, CH2.class.getSuperclass());
        assertEquals(CI.class, CI2.class.getSuperclass());
    }

    public void testInterfaces() {
        checkClassArray(new Class[0], IA.class.getInterfaces());
        checkClassArray(new Class[] { IA.class }, IB.class.getInterfaces());
        checkClassArray(new Class[] { IB.class }, IC.class.getInterfaces());
        checkClassArray(new Class[] { IB.class }, ID.class.getInterfaces());
        checkClassArray(new Class[0], IE.class.getInterfaces());
        checkClassArray(new Class[] { IA.class }, IF.class.getInterfaces());
        checkClassArray(new Class[] { IE.class }, IG.class.getInterfaces());
        checkClassArray(new Class[] { IE.class, IB.class }, IH.class.getInterfaces());
        checkClassArray(new Class[0], CA.class.getInterfaces());
        checkClassArray(new Class[0], CB.class.getInterfaces());
        checkClassArray(new Class[0], CC.class.getInterfaces());
        checkClassArray(new Class[] { IC.class }, CD.class.getInterfaces());
        checkClassArray(new Class[] { IE.class }, CE.class.getInterfaces());
        checkClassArray(new Class[] { IE.class, IB.class }, CF.class.getInterfaces());
        checkClassArray(new Class[] { IC.class }, CG.class.getInterfaces());
        checkClassArray(new Class[] { IE.class }, CH.class.getInterfaces());
        checkClassArray(new Class[] { IE.class, IB.class }, CI.class.getInterfaces());
        checkClassArray(new Class[0], CA2.class.getInterfaces());
        checkClassArray(new Class[0], CB2.class.getInterfaces());
        checkClassArray(new Class[0], CC2.class.getInterfaces());
        checkClassArray(new Class[0], CD2.class.getInterfaces());
        checkClassArray(new Class[0], CE2.class.getInterfaces());
        checkClassArray(new Class[0], CF2.class.getInterfaces());
        checkClassArray(new Class[0], CG2.class.getInterfaces());
        checkClassArray(new Class[0], CH2.class.getInterfaces());
        checkClassArray(new Class[0], CI2.class.getInterfaces());
    }

    private void checkClassArray(Class[] expected, Class[] actual) {
        if (expected == null) {
            assertNull(actual);
            return;
        }
        if (expected != null)
            assertNotNull(actual);
        assertEquals(expected.length, actual.length);
        for (int i = 0; i < expected.length; i++) {
            assertEquals(expected[i], actual[i]);
        }
    }

    public void testIsAssignableFrom() {
        assertEquals(true, Number.class.isAssignableFrom(Integer.class));
        //
        assertEquals(0, int.class.getInterfaces().length);
        assertEquals(null, int.class.getSuperclass());
        assertEquals("int", int.class.getName());
    }

}