/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/09 17:01:57
 */
package test.ognl;

import ognl.Ognl;
import ognl.OgnlException;
import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class OgnlTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(OgnlTest.class);
    }

    public static class TestObject {
        public static final String PROPERTY1 = "property1";

    }

    public void testSimpleStaticAccess() {
        try {
            final String exp = "@" + TestObject.class.getName() + "@PROPERTY1";
            //System.out.println("exp=" + exp);
            //exp=@test.ognl.OgnlTest$TestObject@PROPERTY1
            assertEquals("property1", Ognl.getValue(exp, null));
        } catch (OgnlException e) {
            e.printStackTrace();
            fail();
        }
    }

    public void testSimpleStaticClass() {
        try {
            final String exp = "@" + TestObject.class.getName() + "@class";
            //System.out.println("exp=" + exp);
            //exp=@test.ognl.OgnlTest$TestObject@PROPERTY1
            assertEquals(TestObject.class, Ognl.getValue(exp, null));
        } catch (OgnlException e) {
            e.printStackTrace();
            fail();
        }
    }

}