/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/28
 */
package test.org.asyrinx.brownie.core.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;

import org.apache.commons.collections.map.ListOrderedMap;
import org.asyrinx.brownie.core.collection.CollectionUtils;

/**
 * @author akima
 */
public class CollectionUtilsTest extends TestCase {

    /**
     * Constructor for CollectionUtilsTest.
     * 
     * @param name
     */
    public CollectionUtilsTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CollectionUtilsTest.class);
    }

    /*
     * Test for List toList(Map)
     */
    public void testToListMap() {
        //HashMapƃL[̒ǉsȂ̂ŁAeXgpłSequencedHashMapg܂B
        //SequencedHashMapdeprecatedȂ̂ListOrderedMapg
        final Map source = new ListOrderedMap();
        source.put("a1", "d1");
        source.put("a2", "d2");
        source.put("a3", "d3");
        final List result = CollectionUtils.toList(source);
        assertEquals(3, result.size());
        assertEquals("d1", result.get(0));
        assertEquals("d2", result.get(1));
        assertEquals("d3", result.get(2));
    }

    /*
     * Test for void toList(Map, List)
     */
    public void testToListMapList() {
        //HashMapƃL[̒ǉsȂ̂ŁAeXgpłSequencedHashMapg܂B
        //SequencedHashMapdeprecatedȂ̂ListOrderedMapg
        final Map source = new ListOrderedMap();
        source.put("a1", "d1");
        source.put("a2", "d2");
        source.put("a3", "d3");
        final List result = new ArrayList();
        CollectionUtils.toList(source, result);
        assertEquals(3, result.size());
        assertEquals("d1", result.get(0));
        assertEquals("d2", result.get(1));
        assertEquals("d3", result.get(2));
    }

    /*
     * Test for List toList(Object[])
     */
    public void testToListObjectArray() {
        final String[] source = new String[] { "d1", "d2", "d3" };
        final List result = CollectionUtils.toList(source);
        assertEquals(3, result.size());
        assertEquals("d1", result.get(0));
        assertEquals("d2", result.get(1));
        assertEquals("d3", result.get(2));
    }

    /*
     * Test for void toList(Object[], List)
     */
    public void testToListObjectArrayList() {
        final String[] source = new String[] { "d1", "d2", "d3" };
        final List result = new ArrayList();
        CollectionUtils.toList(source, result);
        assertEquals(3, result.size());
        assertEquals("d1", result.get(0));
        assertEquals("d2", result.get(1));
        assertEquals("d3", result.get(2));
    }

    /*
     * Test for Object find(List, int)
     */
    public void testFindListint() {
        final String[] source = new String[] { "d1", "d2", "d3" };
        final List sourceList = CollectionUtils.toList(source);
        final Object r0 = CollectionUtils.find(sourceList, source[0].hashCode());
        assertEquals(source[0], r0);
        final Object r1 = CollectionUtils.find(sourceList, source[1].hashCode());
        assertEquals(source[1], r1);
        final Object r2 = CollectionUtils.find(sourceList, source[2].hashCode());
        assertEquals(source[2], r2);
    }

    public void testHasDuplicates() {
        final String[] source1 = new String[] { "d1", "d2", "d3" };
        assertFalse(CollectionUtils.hasDuplicates(CollectionUtils.toList(source1)));
        final String[] source2 = new String[] { "d1", "d2", "d3", "d2" };
        assertTrue(CollectionUtils.hasDuplicates(CollectionUtils.toList(source2)));
        final String[] source3 = new String[] { "d1", null, "d2", "d3", null };
        assertTrue(CollectionUtils.hasDuplicates(CollectionUtils.toList(source3)));
    }

    public void testRemoveFromFirst() {
        final String[] source = new String[] { "d1", "d2", "d3", "d4", "d5", "d6", };
        final List list = CollectionUtils.toList(source);
        CollectionUtils.removeFromFirst(list, 4);
        assertEquals(2, list.size());
        assertEquals("d5", list.get(0));
        assertEquals("d6", list.get(1));
    }

    public void testRemoveFromLast() {
        final String[] source = new String[] { "d1", "d2", "d3", "d4", "d5", "d6", };
        final List list = CollectionUtils.toList(source);
        CollectionUtils.removeFromLast(list, 3);
        assertEquals(3, list.size());
        assertEquals("d1", list.get(0));
        assertEquals("d2", list.get(1));
        assertEquals("d3", list.get(2));
    }

    public void testRemoveFromIndex() {
        final String[] source = new String[] { "d1", "d2", "d3", "d4", "d5", "d6", };
        final List list = CollectionUtils.toList(source);
        CollectionUtils.removeFromIndex(list, 2, 3);
        assertEquals(3, list.size());
        assertEquals("d1", list.get(0));
        assertEquals("d2", list.get(1));
        assertEquals("d6", list.get(2));
    }

    public void testRemoveFromIndexReverse() {
        final String[] source = new String[] { "d1", "d2", "d3", "d4", "d5", "d6", };
        final List list = CollectionUtils.toList(source);
        CollectionUtils.removeFromIndex(list, 3, -3);
        assertEquals(3, list.size());
        assertEquals("d1", list.get(0));
        assertEquals("d5", list.get(1));
        assertEquals("d6", list.get(2));
    }

}