/*
 * Created on 2004/03/08 2:23:29
 */
package test.org.asyrinx.brownie.core.collection;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.collection.IntegerKeyMap;
import org.asyrinx.brownie.core.collection.MapUtils;
import org.asyrinx.brownie.core.collection.StringKeyMap;

/**
 * @author akima
 */
public class MapUtilsTest extends TestCase {

	/**
	 * Constructor for MapUtilsTest.
	 * @param arg0
	 */
	public MapUtilsTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(MapUtilsTest.class);
	}

	public void testToIntegerKeyMap() {
		final Map wrapped = new HashMap();
		final IntegerKeyMap map = MapUtils.toIntegerKeyMap(wrapped);
		map.put(1, "111");
		map.put(2, "222");
		assertEquals(2, wrapped.size());
		assertEquals(true, wrapped.containsKey(new Integer(1)));
		assertEquals(true, wrapped.containsKey(new Integer(2)));
		assertEquals("111", wrapped.get(new Integer(1)));
		assertEquals("222", wrapped.get(new Integer(2)));
	}

	public void testToStringKeyMap() {
		final Map wrapped = new HashMap();
		final StringKeyMap map = MapUtils.toStringKeyMap(wrapped);
		map.put("1", "111");
		map.put("2", "222");
		assertEquals(2, wrapped.size());
		assertEquals("111", wrapped.get("1"));
		assertEquals("222", wrapped.get("2"));
	}

}
