/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/05 2:39:14
 */
package test.org.asyrinx.brownie.core.collection.calc;

import junit.framework.TestCase;

import org.apache.commons.lang.ArrayUtils;
import org.asyrinx.brownie.core.collection.calc.Calculation;

/**
 * @author akima
 */
public class CalculationTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CalculationTest.class);
    }

    private void check(Calculation calculation, int expected, int[] values) {
        final Number result = calculation.calculate(ArrayUtils.toObject(values));
        assertEquals(expected, result.intValue());
    }

    private void check(Calculation calculation, double expected, double[] values) {
        final Number result = calculation.calculate(ArrayUtils.toObject(values));
        assertEquals(expected, result.doubleValue(), 0);
    }

    public void testSummary() {
        check(Calculation.SUMMARY, 0, new int[] {});
        check(Calculation.SUMMARY, 0, new int[] { 0 });
        check(Calculation.SUMMARY, 1, new int[] { 1 });
        check(Calculation.SUMMARY, 123, new int[] { 4, 3, 1, 6, 9, 100 });
    }

    public void testCount() {
        check(Calculation.COUNT, 0, new int[] {});
        check(Calculation.COUNT, 1, new int[] { 0 });
        check(Calculation.COUNT, 3, new int[] { 0, 0, 0 });
        check(Calculation.COUNT, 5, new int[] { 1, 3, -100, 9, 10 });
    }

    public void testAverage() {
        check(Calculation.AVERAGE, 0, new double[] {});
        check(Calculation.AVERAGE, 0, new double[] { 0 });
        check(Calculation.AVERAGE, 1, new double[] { 1 });
        check(Calculation.AVERAGE, 1.5, new double[] { 1, 2 });
        check(Calculation.AVERAGE, 3, new double[] { 1, 3, 5 });
    }

    public void testMax() {
        check(Calculation.MAX, 0, new double[] {});
        check(Calculation.MAX, 0, new double[] { 0 });
        check(Calculation.MAX, 1, new double[] { 1 });
        check(Calculation.MAX, 2, new double[] { 1, 2 });
        check(Calculation.MAX, 5, new double[] { 1, 3, 5 });
        check(Calculation.MAX, -1, new double[] { -1, -3, -5 });
    }

    public void testMin() {
        check(Calculation.MIN, 0, new double[] {});
        check(Calculation.MIN, 0, new double[] { 0 });
        check(Calculation.MIN, 1, new double[] { 1 });
        check(Calculation.MIN, 1, new double[] { 1, 2 });
        check(Calculation.MIN, 1, new double[] { 1, 3, 5 });
        check(Calculation.MIN, -5, new double[] { -1, -3, -5 });
    }

}