/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/19 14:07:40
 */
package test.org.asyrinx.brownie.core.csv;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.csv.SVParserListener;
import org.asyrinx.brownie.core.csv.SimpleSVParser;

/**
 * @author akima
 */
public class SimpleSVParserTest extends TestCase {

	/**
	 * Constructor for SVParserTest.
	 * @param arg0
	 */
	public SimpleSVParserTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(SimpleSVParserTest.class);
	}

	public void testParse() {
		checkSV(
			"1\t2,3\tRRRR\n2\tRUYIOUO\tWWWWWaaaa",
			"1<delim>2,3<delim>RRRR\n2<delim>RUYIOUO<delim>WWWWWaaaa\n",
			"\t");
		checkSV(
			"1\t2,3\tRRRR\n2\tRUYIOUO\tWWWWWaaaa\n",
			"1<delim>2,3<delim>RRRR\n2<delim>RUYIOUO<delim>WWWWWaaaa\n",
			"\t");
		checkSV(
			"1\t2,3\tRRRR\n2\tRUYIOUO\tWWWWWaaaa\n",
			"1\t2<delim>3\tRRRR\n2\tRUYIOUO\tWWWWWaaaa\n",
			",");
	}

	private void checkSV(
		final String testTsv1,
		final String correct,
		final String delim) {
		final StringBuffer result = new StringBuffer();
		final CharArrayReader reader =
			new CharArrayReader(testTsv1.toCharArray());
		final SVParserListener listener = new SVParserListener() {
			/* (non-Javadoc)
			 * @see org.asyrinx.brownie.core.text.SVParserListener#onLine(java.util.List)
			 */
			public void onLine(List lines) {
				boolean isFirst = true;
				for (Iterator iter = lines.iterator(); iter.hasNext();) {
					if (isFirst)
						isFirst = false;
					else {
						//result.append(delim);
						result.append("<delim>");
					}
					final String element = (String) iter.next();
					result.append(element);
				}
				result.append("\n");
			}
		};
		final SimpleSVParser parser = new SimpleSVParser();
		parser.addListener(listener);
		parser.setDelimeter(delim);
		try {
			parser.parse(reader);
		} catch (IOException e) {
			e.printStackTrace();
			fail();
		}
		//System.out.println(result.toString());
		assertEquals(correct, result.toString());
	}
}
