/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/20 21:21:43
 */
package test.org.asyrinx.brownie.core.lang;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.lang.MethodUtils;

/**
 * @author takeshi
 */
public class MethodUtilsTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(MethodUtilsTest.class);
    }

    public static class A {
        public static String concat(String arg1, String arg2) {
            return arg1 + arg2;
        }
    }

    public static class B extends A {
        //just extends A
    }

    public void testInvokeStaticMethod() {
        try {
            assertEquals("123456", MethodUtils.invokeStaticMethod(A.class, "concat", new Object[] {
                    "123", "456" }));
            assertEquals("123456", MethodUtils.invokeStaticMethod(B.class, "concat", new Object[] {
                    "123", "456" }));
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }
    }

}