/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/09 17:53:31
 */
package test.org.asyrinx.brownie.core.text;

import org.asyrinx.brownie.core.text.EscapedStringSplitter;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class EscapedStringSplitterTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(EscapedStringSplitterTest.class);
    }

    public void testSplit1() {
        final EscapedStringSplitter splitter = new EscapedStringSplitter(',', '\\');
        checkEquals(new String[] {}, splitter.execute(null));
        checkEquals(new String[] { "" }, splitter.execute(""));
        checkEquals(new String[] { "aaa" }, splitter.execute("aaa"));
        checkEquals(new String[] { "aaa", "bbb", "ccc" }, splitter.execute("aaa,bbb,ccc"));
        checkEquals(new String[] { "HAN_NUMERIC", ",." }, splitter.execute("HAN_NUMERIC,\\,."));
        checkEquals(new String[] { "", "HAN_NUMERIC", ",." }, splitter.execute(",HAN_NUMERIC,\\,."));
        checkEquals(new String[] { "", "", "HAN_NUMERIC", ",." }, splitter
                .execute(",,HAN_NUMERIC,\\,."));
        checkEquals(new String[] { ",", "HAN_NUMERIC", "" }, splitter.execute("\\,,HAN_NUMERIC,"));
    }

    /**
     * @param strings
     * @param strings2
     */
    private void checkEquals(String[] strings, String[] strings2) {
        assertEquals(strings.length, strings2.length);
        for (int i = 0; i < strings.length; i++) {
            assertEquals("strings[" + i + "] was different", strings[i], strings2[i]);
        }
    }

}