/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package test.org.asyrinx.brownie.core.util;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.util.SimpleDate;
import org.asyrinx.brownie.core.util.SimpleDateRange;

/**
 * @author akima
 */
public class SimpleDateRangeTest extends TestCase {

	/**
	 * Constructor for SimpleDateRangeTest.
	 * @param name
	 */
	public SimpleDateRangeTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(SimpleDateRangeTest.class);
	}

	/*
	 * Test for boolean equals(Object)
	 */
	public void testEqualsObject() {
		final SimpleDateRange range10 = new SimpleDateRange(null, null);
		final SimpleDateRange range11 =
			new SimpleDateRange(new SimpleDate(2003, 0, 1), null);
		final SimpleDateRange range12 =
			new SimpleDateRange(null, new SimpleDate(2003, 11, 31));
		final SimpleDateRange range13 =
			new SimpleDateRange(
				new SimpleDate(2003, 0, 1),
				new SimpleDate(2003, 11, 31));
		//
		final SimpleDateRange range20 = new SimpleDateRange(null, null);
		final SimpleDateRange range21 =
			new SimpleDateRange(new SimpleDate(2003, 0, 1), null);
		final SimpleDateRange range22 =
			new SimpleDateRange(null, new SimpleDate(2003, 11, 31));
		final SimpleDateRange range23 =
			new SimpleDateRange(
				new SimpleDate(2003, 0, 1),
				new SimpleDate(2003, 11, 31));
		final SimpleDateRange range24 =
			new SimpleDateRange(
				new SimpleDate(2003, 2, 1),
				new SimpleDate(2003, 11, 31));
		final SimpleDateRange range25 =
			new SimpleDateRange(
				new SimpleDate(2003, 1, 1),
				new SimpleDate(2003, 10, 30));
		//
		assertEquals(range10, range20);
		assertEquals(range11, range21);
		assertEquals(range12, range22);
		assertEquals(range13, range23);
		assertFalse(range13.equals(range24));
		assertFalse(range13.equals(range25));
	}

	/*
	 * Test for boolean include(SimpleDate)
	 */
	public void testIncludeSimpleDate() {
		final SimpleDateRange range10 = new SimpleDateRange(null, null);
		final SimpleDateRange range11 =
			new SimpleDateRange(new SimpleDate(2003, 0, 1), null);
		final SimpleDateRange range12 =
			new SimpleDateRange(null, new SimpleDate(2003, 11, 31));
		final SimpleDateRange range13 =
			new SimpleDateRange(
				new SimpleDate(2003, 0, 1),
				new SimpleDate(2003, 11, 31));
		//
		final SimpleDate d1 = new SimpleDate(2002, 11, 31);
		final SimpleDate d2 = new SimpleDate(2003, 0, 1);
		final SimpleDate d3 = new SimpleDate(2003, 8, 15);
		final SimpleDate d4 = new SimpleDate(2003, 11, 31);
		final SimpleDate d5 = new SimpleDate(2004, 0, 1);
		//
		assertTrue(range10.include(d1));
		assertTrue(range10.include(d2));
		assertTrue(range10.include(d3));
		assertTrue(range10.include(d4));
		assertTrue(range10.include(d5));
		//
		assertFalse(range11.include(d1));
		assertTrue(range11.include(d2));
		assertTrue(range11.include(d3));
		assertTrue(range11.include(d4));
		assertTrue(range11.include(d5));
		//
		assertTrue(range12.include(d1));
		assertTrue(range12.include(d2));
		assertTrue(range12.include(d3));
		assertTrue(range12.include(d4));
		assertFalse(range12.include(d5));
		//
		assertFalse(range13.include(d1));
		assertTrue(range13.include(d2));
		assertTrue(range13.include(d3));
		assertTrue(range13.include(d4));
		assertFalse(range13.include(d5));
	}

}
