package test.org.asyrinx.brownie.pdf.fop.impl;

import java.io.Serializable;


import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * PartyTelephone [ dbԍ ]
 * 
 * @hibernate.class table="${table.getName()}"
 */
public class PartyTelephone implements Serializable {

    public PartyTelephone() {
        super();
    }

    public PartyTelephone(long telephoneId, long partyId, String ctiNumber,
            String displayNumber, int telephoneTypeId) {
        super();
        this.telephoneId = telephoneId;
        this.partyId = partyId;
        this.ctiNumber = ctiNumber;
        this.displayNumber = displayNumber;
        this.telephoneTypeId = telephoneTypeId;
    }

    /* --------------------Properties -------------------- */
    /** telephoneId [ dbԍID ] */
    private long telephoneId = 0;

    /** partyId [ p[eBID ] */
    private long partyId = 0;

    /** ctiNumber [ CTIpdbԍ ] */
    private String ctiNumber = null;

    /** displayNumber [ \pdbԍ ] */
    private String displayNumber = null;

    /** telephoneTypeId [ dbID ] */
    private int telephoneTypeId = 0;

    /**
     * Get the telephoneId [ dbԍID ]
     * 
     * @return long
     */
    public long getTelephoneId() {
        return telephoneId;
    }

    /**
     * Get the partyId [ p[eBID ]
     * 
     * @return long
     */
    public long getPartyId() {
        if ((partyId == 0) && (this.getParty() != null))
            return party.getPartyId();
        else
            return partyId;
    }

    /**
     * Get the ctiNumber [ CTIpdbԍ ]
     * 
     * @return String
     */
    public String getCtiNumber() {
        return ctiNumber;
    }

    /**
     * Get the displayNumber [ \pdbԍ ]
     * 
     * @return String
     */
    public String getDisplayNumber() {
        return displayNumber;
    }

    /**
     * Get the telephoneTypeId [ dbID ]
     * 
     * @return int
     */
    public int getTelephoneTypeId() {
        return telephoneTypeId;
    }

    /**
     * Set the telephoneId [ dbԍID ]
     * 
     * @param value
     *               new value
     */
    public void setTelephoneId(long value) {
        this.telephoneId = value;
    }

    /**
     * Set the partyId [ p[eBID ]
     * 
     * @param value
     *               new value
     */
    public void setPartyId(long value) {
        this.partyId = value;
    }

    /**
     * Set the ctiNumber [ CTIpdbԍ ]
     * 
     * @param value
     *               new value
     */
    public void setCtiNumber(String value) {
        this.ctiNumber = value;
    }

    /**
     * Set the displayNumber [ \pdbԍ ]
     * 
     * @param value
     *               new value
     */
    public void setDisplayNumber(String value) {
        this.displayNumber = value;
    }

    /**
     * Set the telephoneTypeId [ dbID ]
     * 
     * @param value
     *               new value
     */
    public void setTelephoneTypeId(int value) {
        this.telephoneTypeId = value;
    }

    public TelephoneType getTelephoneType() {
        return TelephoneType.get(this.getTelephoneTypeId());
    }

    public void setTelephoneType(TelephoneType value) {
        this.setTelephoneTypeId(value.asInt());
    }

    /* --------------------Referring Objects -------------------- */
    private Party party = null;

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
        //19820996
        this.partyId = (party == null) ? 0 :
        //entry.getLocal() = org.asyrinx.joey.gen.model.java.Property@166cb16
                //entry.getLocal().hashCode() = 23513878
                party.getPartyId();
    }

    public Serializable getPartyKey() {
        return (this.getPartyId() == 0) ? null : new Long(this.getPartyId());
    }

    /* --------------------Referred Objects -------------------- */

    /**
     * returns an id that differentiates this object from others of its class.
     */
    public Serializable getPrimaryKey() {
        return new Long(getTelephoneId());
    }

    public boolean equals(Object other) {
        if (!(other instanceof PartyTelephone))
            return false;
        PartyTelephone castOther = (PartyTelephone) other;
        return new EqualsBuilder().append(this.getTelephoneId(),
                castOther.getTelephoneId()).append(this.getPartyId(),
                castOther.getPartyId()).append(this.getCtiNumber(),
                castOther.getCtiNumber()).append(this.getDisplayNumber(),
                castOther.getDisplayNumber()).append(this.getTelephoneTypeId(),
                castOther.getTelephoneTypeId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getTelephoneId()).append(
                this.getPartyId()).append(this.getCtiNumber()).append(
                this.getDisplayNumber()).append(this.getTelephoneTypeId())
                .toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("telephoneId",
                this.getTelephoneId()).append("partyId", this.getPartyId())
                .append("ctiNumber", this.getCtiNumber()).append(
                        "displayNumber", this.getDisplayNumber()).append(
                        "telephoneTypeId", this.getTelephoneTypeId())
                .toString();
    }

}