package test.org.asyrinx.brownie.pdf.fop.impl;

import java.util.List;

import org.apache.commons.lang.enum.Enum;
import org.asyrinx.brownie.core.lang.enum.ValuedEnum;

/**
 *  
 */
public class TelephoneType extends ValuedEnum {
    private TelephoneType(String caption, int value) {
        super(caption, new Integer(value));
    }

    public int asInt() {
        return ((Integer) getValue()).intValue();
    }

    public static TelephoneType get(int value) {
        return (TelephoneType) ValuedEnum.getEnum(TelephoneType.class,
                new Integer(value));
    }

    public static List getList() {
        return Enum.getEnumList(TelephoneType.class);
    }

    public static TelephoneType getEnum(String name) {
        return (TelephoneType) Enum.getEnum(TelephoneType.class, name);
    }

    public String toString() {
        return getName();
    }

    public static final TelephoneType NORMAL = new TelephoneType("db", 1);

    public static final TelephoneType FAX = new TelephoneType("FAX", 2);

    public static final TelephoneType MOBILE = new TelephoneType("g", 3);

    public static final TelephoneType OTHER = new TelephoneType("̑", 4);
}