<?xml version="1.0" encoding="Shift_JIS"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="barcode date">
	<xsl:output method="xml" encoding="Shift_JIS" indent="yes"/>
	<xsl:decimal-format name="std" decimal-separator="." grouping-separator="'" infinity="#x221E" minus-sign="-"/>
	<!--  
	<xsl:processing-instruction name="cocoon-format"> type="text/xslfo" </xsl:processing-instruction>
	-->
	<!--  -->
	<xsl:template match="/">
		<xsl:apply-templates/>
	</xsl:template>
	<!--  party -->
	<xsl:template match="party">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master page-width="21cm" page-height="29.7cm" master-name="A4">
					<fo:region-body margin-bottom="1.5cm" margin-right="2cm" margin-left="2cm" margin-top="1.5cm"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="A4">
				<fo:flow flow-name="xsl-region-body">
					<fo:wrapper font-family="MSGothic">
						<fo:block space-after.optimum="6pt"> p[eBR[h:    <xsl:value-of select="partyCode" /> </fo:block>
						<fo:block space-after.optimum="6pt"> Ji:    <xsl:value-of select="nameKana" /> </fo:block>
						<fo:block space-after.optimum="6pt"> :    <xsl:value-of select="name" /> </fo:block>
						<fo:table border-color="black" border-width="0.5pt" border-style="solid">
							<fo:table-column column-width="20mm"/>
							<fo:table-column column-width="50mm"/>
							<fo:table-header>
								<fo:table-row>
									<fo:table-cell border-color="black" border-width="0.5pt" border-style="solid">
										<fo:block font-weight="bold" font-family="MSGothic"></fo:block>
									</fo:table-cell>
									<fo:table-cell border-color="black" border-width="0.5pt" border-style="solid">
										<fo:block font-weight="bold" font-family="MSGothic">A</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-header>
							<fo:table-body>
								<xsl:for-each select="partyTelephones">
									<fo:table-row>
										<fo:table-cell column-number="1" border-color="black" border-width="0.5pt" border-style="solid">
											<fo:block>db</fo:block>
										</fo:table-cell>
										<fo:table-cell column-number="2" border-color="black" border-width="0.5pt" border-style="solid">
											<fo:block>
												<xsl:value-of select="displayNumber" />
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:for-each>
							</fo:table-body>
						</fo:table>
					</fo:wrapper>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<!--  -->
</xsl:stylesheet>