/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/06/19 13:47:41
 */
package test.org.asyrinx.brownie.swing.table;

import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import junit.framework.TestCase;

import org.apache.commons.lang.ObjectUtils;
import org.asyrinx.brownie.swing.table.TableUtils;
import org.asyrinx.brownie.swing.table.util.ArrayAccessibleTableModel;
import org.asyrinx.brownie.swing.table.util.SimpleSortableTableModel;

/**
 * @author akima
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class TableUtilsTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(TableUtilsTest.class);
    }

    /*
     * (non-Javadoc)
     * 
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        tableModel = new DefaultTableModel();
        tableModel.addColumn("col0");
        tableModel.addColumn("col1");
        tableModel.addColumn("col2");
        tableModel.addColumn("col3");
        tableModel.addColumn("col4");
        tableModel.addRow(new Object[] { "0-0", "1-0", "2-0", "1", "z" });
        tableModel.addRow(new Object[] { "0-1", "1-1", "2-1", "2", "x" });
        tableModel.addRow(new Object[] { "0-2", "1-2", "2-2", "11", "a" });
        tableModel.addRow(new Object[] { "0-3", "1-3", "2-3", "00", "y" });
    }

    private DefaultTableModel tableModel = null;

    public void testToUneditableModel() {
        TableModel unmodifiedModel = TableUtils.toUneditableModel(tableModel);
        for (int y = 0; y < unmodifiedModel.getColumnCount(); y++) {
            for (int x = 0; x < unmodifiedModel.getColumnCount(); x++) {
                assertEquals(false, unmodifiedModel.isCellEditable(y, x));
            }
        }
        //setValueAt\bhOK
        unmodifiedModel.setValueAt("modified", 1, 1);
        assertEquals("modified", unmodifiedModel.getValueAt(1, 1));
    }

    public void testToInvisibleColumnModel() {
        //0ڂ2\
        final TableModel invisibleModel1 = TableUtils.toInvisibleColumnModel(tableModel, 0, 2);
        assertEquals(5, tableModel.getColumnCount());
        assertEquals(3, invisibleModel1.getColumnCount());
        assertEquals("2-0", invisibleModel1.getValueAt(0, 0));
        assertEquals("2-1", invisibleModel1.getValueAt(1, 0));
        assertEquals("2-2", invisibleModel1.getValueAt(2, 0));
        assertEquals("2-3", invisibleModel1.getValueAt(3, 0));
        assertEquals("1", invisibleModel1.getValueAt(0, 1));
        assertEquals("2", invisibleModel1.getValueAt(1, 1));
        assertEquals("11", invisibleModel1.getValueAt(2, 1));
        assertEquals("00", invisibleModel1.getValueAt(3, 1));
        assertEquals("z", invisibleModel1.getValueAt(0, 2));
        assertEquals("x", invisibleModel1.getValueAt(1, 2));
        assertEquals("a", invisibleModel1.getValueAt(2, 2));
        assertEquals("y", invisibleModel1.getValueAt(3, 2));
        //1ڂ3\
        final TableModel invisibleModel2 = TableUtils.toInvisibleColumnModel(tableModel, 1, 3);
        assertEquals(5, tableModel.getColumnCount());
        assertEquals(2, invisibleModel2.getColumnCount());
        assertEquals("0-0", invisibleModel2.getValueAt(0, 0));
        assertEquals("0-1", invisibleModel2.getValueAt(1, 0));
        assertEquals("0-2", invisibleModel2.getValueAt(2, 0));
        assertEquals("0-3", invisibleModel2.getValueAt(3, 0));
        assertEquals("z", invisibleModel2.getValueAt(0, 1));
        assertEquals("x", invisibleModel2.getValueAt(1, 1));
        assertEquals("a", invisibleModel2.getValueAt(2, 1));
        assertEquals("y", invisibleModel2.getValueAt(3, 1));
    }

    public void testToSortableModel() {
        final SimpleSortableTableModel sortable = TableUtils.toSortableModel(tableModel);
        //Ԃ̓\[gĂȂ
        assertEquals("0-0", sortable.getValueAt(0, 0));
        assertEquals("0-1", sortable.getValueAt(1, 0));
        assertEquals("0-2", sortable.getValueAt(2, 0));
        assertEquals("0-3", sortable.getValueAt(3, 0));
        assertEquals("1", sortable.getValueAt(0, 3));
        assertEquals("2", sortable.getValueAt(1, 3));
        assertEquals("11", sortable.getValueAt(2, 3));
        assertEquals("00", sortable.getValueAt(3, 3));
        assertEquals("z", sortable.getValueAt(0, 4));
        assertEquals("x", sortable.getValueAt(1, 4));
        assertEquals("a", sortable.getValueAt(2, 4));
        assertEquals("y", sortable.getValueAt(3, 4));
        //3ڂŃ\[g
        sortable.sort(3, false);
        assertEquals("0-3", sortable.getValueAt(0, 0));
        assertEquals("0-0", sortable.getValueAt(1, 0));
        assertEquals("0-2", sortable.getValueAt(2, 0));
        assertEquals("0-1", sortable.getValueAt(3, 0));
        assertEquals("00", sortable.getValueAt(0, 3));
        assertEquals("1", sortable.getValueAt(1, 3));
        assertEquals("11", sortable.getValueAt(2, 3));
        assertEquals("2", sortable.getValueAt(3, 3));
        assertEquals("y", sortable.getValueAt(0, 4));
        assertEquals("z", sortable.getValueAt(1, 4));
        assertEquals("a", sortable.getValueAt(2, 4));
        assertEquals("x", sortable.getValueAt(3, 4));
        //4ڂŃ\[g
        sortable.sort(4, false);
        assertEquals("0-2", sortable.getValueAt(0, 0));
        assertEquals("0-1", sortable.getValueAt(1, 0));
        assertEquals("0-3", sortable.getValueAt(2, 0));
        assertEquals("0-0", sortable.getValueAt(3, 0));
        assertEquals("11", sortable.getValueAt(0, 3));
        assertEquals("2", sortable.getValueAt(1, 3));
        assertEquals("00", sortable.getValueAt(2, 3));
        assertEquals("1", sortable.getValueAt(3, 3));
        assertEquals("a", sortable.getValueAt(0, 4));
        assertEquals("x", sortable.getValueAt(1, 4));
        assertEquals("y", sortable.getValueAt(2, 4));
        assertEquals("z", sortable.getValueAt(3, 4));
    }

    public void testToCalculatableKey2() {
        final DefaultTableModel model = new DefaultTableModel();
        model.addColumn("key");
        model.addColumn("col1");
        model.addColumn("col2");
        model.addColumn("col3");
        model.addColumn("col4");
        model.addRow(new Object[] { "A", "1", "2-0", "1", "z" });
        model.addRow(new Object[] { "A", "6", "2-0", "1", "z" });
        model.addRow(new Object[] { "A", "-10", "2-1", "2", "x" });
        model.addRow(new Object[] { "B", "20", "2-2", "11", "a" });
        model.addRow(new Object[] { "C", "123", "2-3", "00", "z" });
        model.addRow(new Object[] { "C", "11", "2-3", "00", "y" });
        model.addRow(new Object[] { "C", "99", "2-3", "00", "y" });
        //
        final TableModel calculatable = TableUtils.toSortable(model, new int[] { 4, 0 });
        final ArrayAccessibleTableModel at = TableUtils.toArrayAccessible(calculatable);
        //
        assertEquals(5, calculatable.getColumnCount());
        assertEquals(7, calculatable.getRowCount());
        assertEquals("key", calculatable.getColumnName(0));
        assertEquals("col1", calculatable.getColumnName(1));
        assertEquals("col2", calculatable.getColumnName(2));
        assertEquals("col3", calculatable.getColumnName(3));
        assertEquals("col4", calculatable.getColumnName(4));
        //
        checkArray(at.getRowArray(0), new Object[] { "B", "20", "2-2", "11", "a" });
        checkArray(at.getRowArray(1), new Object[] { "A", "-10", "2-1", "2", "x" });
        checkArray(at.getRowArray(2), new Object[] { "C", "11", "2-3", "00", "y" });
        checkArray(at.getRowArray(3), new Object[] { "C", "99", "2-3", "00", "y" });
        checkArray(at.getRowArray(4), new Object[] { "A", "1", "2-0", "1", "z" });
        checkArray(at.getRowArray(5), new Object[] { "A", "6", "2-0", "1", "z" });
        checkArray(at.getRowArray(6), new Object[] { "C", "123", "2-3", "00", "z" });
    }

    private void checkArray(Object[] value, Object[] expected) {
        assertEquals(true, value.length == expected.length);
        for (int i = 0; i < value.length; i++) {
            assertEquals(true, ObjectUtils.equals(value[i], expected[i]));
        }
    }

}