/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 22:10:02
 */
package test.org.asyrinx.brownie.validator.prop;

import org.asyrinx.brownie.core.chars.Japanese;
import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.brownie.validator.prop.AcceptableCharacters;

import test.org.asyrinx.brownie.validator.JapaneseTestCase;
import test.org.asyrinx.brownie.validator.TestObject;
import test.org.asyrinx.brownie.validator.TestUtils;

/**
 * @author takeshi
 */
public class AcceptableCharacterSetTest extends JapaneseTestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(AcceptableCharacterSetTest.class);
    }

    public void testEvaluate() {
        //pJ^Ji`FbN
        final Validator v = new AcceptableCharacters("stringProperty", "񑮐",
                Japanese.HANKAKU_KATAKANA, true);
        //
        final TestObject object1 = new TestObject();
        //
        object1.setStringProperty(null);
        TestUtils.assertOK(v, object1);
        //
        object1.setStringProperty("123-4567");
        TestUtils.assertOK(v, object1);
        //
        ValidationContext context;
        Message message;
        //
        object1.setStringProperty("44-11");
        context = TestUtils.assertNG(v, object1, 1);
        message = (Message) context.getMessages().get(0);
        assertEquals("񑮐 ɂ pJ^Ji ܂ł͂܂B", message.getText());
        //
        object1.setStringProperty("123");
        TestUtils.assertNG(v, object1);
        //
        object1.setStringProperty("");
        TestUtils.assertNG(v, object1);
    }

}