/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/09 15:59:00
 */
package test.org.asyrinx.brownie.validator.prop;

import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.brownie.validator.prop.RegExp;

import test.org.asyrinx.brownie.validator.JapaneseTestCase;
import test.org.asyrinx.brownie.validator.TestObject;
import test.org.asyrinx.brownie.validator.TestUtils;

/**
 * @author takeshi
 */
public class RegExpTest extends JapaneseTestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(RegExpTest.class);
    }

    public void testEvaluate() {
        //final Validator v = new RegExp("stringProperty", "񑮐",
        // "\\d{3}(-\\d{4})?");
        final Validator v = new RegExp("stringProperty", "񑮐", "[0-9]{3}(-[0-9]{4})?");
        //
        final TestObject object1 = new TestObject();
        //
        object1.setStringProperty(null);
        TestUtils.assertOK(v, object1);
        //
        object1.setStringProperty("");
        TestUtils.assertOK(v, object1);
        //
        object1.setStringProperty("123-1234");
        TestUtils.assertOK(v, object1);
        //
        object1.setStringProperty("123");
        TestUtils.assertOK(v, object1);
        //
        object1.setStringProperty("1231234");
        TestUtils.assertNG(v, object1);
        //
        object1.setStringProperty("123+1234");
        TestUtils.assertNG(v, object1);
        //
        object1.setStringProperty("123-111");
        TestUtils.assertNG(v, object1);
        //
        object1.setStringProperty("1234-1234");
        TestUtils.assertNG(v, object1);
    }

}