/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 11:30:54
 */
package test.org.asyrinx.brownie.validator.prop;

import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.brownie.validator.prop.Required;

import test.org.asyrinx.brownie.validator.JapaneseTestCase;
import test.org.asyrinx.brownie.validator.TestObject;
import test.org.asyrinx.brownie.validator.TestUtils;

/**
 * @author takeshi
 */
public class RequiredTest extends JapaneseTestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(RequiredTest.class);
    }

    public void testRequired() {
        final Validator v = new Required("stringProperty", "񑮐");
        //
        ValidationContext context;
        Message message;
        //
        final TestObject object1 = new TestObject();
        object1.setStringProperty(null);
        TestUtils.assertNG(v, object1, 1);
        //
        object1.setStringProperty("");
        context = TestUtils.assertNG(v, object1, 1);
        message = (Message) context.getMessages().get(0);
        assertEquals("񑮐 ɂ͕K͂ĂB", message.getText());
        //
        object1.setStringProperty("0123456789"); //OK
        TestUtils.assertOK(v, object1);
        object1.setStringProperty(""); //OK
        TestUtils.assertOK(v, object1);
    }

}