package org.junitdoc.ui.decisiontable;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.junitdoc.JUnitDocPlugin;
import org.junitdoc.core.decisiontable.DecisionTableModel;
import org.junitdoc.core.rewriter.ASTUtils;
import org.junitdoc.core.util.JavaModelUtils;
import org.junitdoc.ui.Const;
import org.junitdoc.ui.UIMessages;

public class ExportHtmlAction implements IObjectActionDelegate {

	private Shell shell;

	private IJavaElement javaElement;

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		shell = targetPart.getSite().getShell();
	}

	public void run(IAction action) {
		List<DecisionTableModel> models = new ArrayList<DecisionTableModel>();

		if (javaElement instanceof ICompilationUnit
				|| javaElement instanceof IJavaProject
				|| javaElement instanceof IPackageFragmentRoot
				|| javaElement instanceof IPackageFragment) {

			try {
				collectDecisionTableModel(models);

			} catch (JavaModelException e) {
				JUnitDocPlugin.errorLog("collecting error.", e);
				MessageDialog.openError(shell, "Error",
						"Export DecisionTable Error!");
				return;
			}
		}

		if (models.size() == 0) {
			MessageDialog
					.openInformation(
							shell,
							UIMessages
									.getString("DecisionTableViewPart.export.decisiontable.title"),
							UIMessages
									.getString("DecisionTableViewPart.export.decisiontable.infomation.nofile"));
			return;
		}

		new HtmlExporter(shell, UIMessages
				.getString("DecisionTableViewPart.export.decisiontable.title"),
				models.toArray(new DecisionTableModel[models.size()]), true)
				.export();
	}

	private void collectDecisionTableModel(List<DecisionTableModel> models)
			throws JavaModelException {
		List<ICompilationUnit> units = JavaModelUtils
				.collectICompilationUnits(javaElement);

		for (ICompilationUnit unit : units) {
			List<AnnotationTypeDeclaration> annos = ASTUtils
					.getAnnotationTypeDeclarationsWithAnnotation(ASTUtils
							.createAST(unit), Const.DECISIONTABLE_ANNOTATION);

			for (AnnotationTypeDeclaration anno : annos) {
				String decisionTableName = anno.getName()
						.getFullyQualifiedName();

				DecisionTableModel model = new DecisionTableModel(
						decisionTableName);
				model.parse((CompilationUnit) anno.getRoot());

				models.add(model);
			}
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof StructuredSelection) {
			StructuredSelection ss = (StructuredSelection) selection;
			Object obj = ss.getFirstElement();

			javaElement = (IJavaElement) obj;
		}
	}
}
