package org.junitdoc.ui.decisiontable;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.junitdoc.JUnitDocPlugin;
import org.junitdoc.preferences.PreferenceConstants;

public class TestResourceViewPart extends ViewPart {

	private Composite parent;

	private TreeViewer viewer;

	private ISelectionListener listener = new ISelectionListener() {
		public void selectionChanged(IWorkbenchPart workbenchPart,
				ISelection selection) {

			JUnitDocPlugin.debugLog("TestResourceViewPart selectionChanged");
			JUnitDocPlugin.debugLog(selection.getClass());
			JUnitDocPlugin.debugLog(selection);

			if (selection.isEmpty()) {
				return;
			}

			if (selection instanceof IStructuredSelection) {
				IStructuredSelection s = (IStructuredSelection) selection;
				final Object firstElement = s.getFirstElement();

				System.out.println("firstElement:" + firstElement);
				System.out.println(firstElement.getClass());

				Display d = viewer.getControl().getDisplay();
				if (d != null) {
					d.asyncExec(new Runnable() {
						public void run() {

							if (firstElement instanceof IFile) {
								update((IFile) firstElement);

							} else if (firstElement instanceof ICompilationUnit) {
								ICompilationUnit unit = (ICompilationUnit) firstElement;
								IResource resource = unit.getResource();
								if (resource instanceof IFile) {
									update((IFile) resource);
								}
							}
						}
					});
				}

			}
		}
	};

	public void update(IFile file) {
		JUnitDocPlugin.debugLog("TestResourceViewPart update... " + file);
		viewer.setInput(makeData(file));
	}

	private Object makeData(IFile file) {
		if (isMainJava(file)) {

			TreeNode[] parent = new TreeNode[2];
			parent[0] = new TreeNode(new LinkViewModel("TestCase", 1));
			parent[1] = new TreeNode(new LinkViewModel("TestResource", 1));

			IFile[] testCases = ResourceUtils.findTestCases(file);
			TreeNode[] childs = new TreeNode[testCases.length];

			int index = 0;
			for (IFile testCase : testCases) {
				childs[index] = new TreeNode(new LinkViewModel(testCase, 2));
				childs[index].setParent(parent[0]);
				index++;
			}
			parent[0].setChildren(childs);

			return parent;
		}
		return null;
	}

	private boolean isMainJava(IFile file) {
		IPreferenceStore store = JUnitDocPlugin.getDefault().getPreferenceStore();
		String mainJavaPath = store.getString(PreferenceConstants.P_MAINJAVA);
		String projectName = ResourceUtils.getProjectName(file);

		if (file.getFullPath().toPortableString().startsWith(
				"/" + projectName + "/" + mainJavaPath)) {
			return true;
		}
		return false;
	}

	public void createPartControl(Composite parent) {
		JUnitDocPlugin.debugLog("TestResourceViewPart　createPart");

		this.parent = parent;

		viewer = new TreeViewer(parent, SWT.NONE);
		viewer.setContentProvider(new TreeNodeContentProvider());
		viewer.setLabelProvider((new LabelProvider() {
			@Override
			public String getText(Object element) {
				if (element instanceof TreeNode) {
					TreeNode node = (TreeNode) element;
					LinkViewModel value = (LinkViewModel) node.getValue();
					return value.getName();
				}
				return super.getText(element);
			}
		}));

		getSite().getPage().addPostSelectionListener(listener);
	}

	@Override
	public void dispose() {
		JUnitDocPlugin.debugLog("TestResourceViewPart dispose()");
		getSite().getPage().removeSelectionListener(listener);
		super.dispose();
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		// tabPage.getControl().setFocus();
	}

	public static class LinkViewModel {
		private String name;
		private int type = 0;
		private IFile testCaseFile;

		public LinkViewModel(String name, int type) {
			this.name = name;
			this.type = type;
		}

		public LinkViewModel(IFile testCase, int i) {
			this(testCase.getName(), i);
			this.testCaseFile = testCase;
		}

		public String getName() {
			return name;
		}

		public int getType() {
			return type;
		}
	}
}