/*
Copyright (C) 2012-2013 Taisuke Kobayashi
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class BaseCanvas extends Canvas implements KeyListener, MouseListener, MouseMotionListener {

  protected Snapshot snapshot;
  protected int drawX = 0, drawY = 0, mouseX = 0, mouseY = 0;
  protected boolean canvasClearFlag = false;
  protected String imageDir;
  protected final int MENU_NORMAL = 0, MENU_USERID = 1;
  protected int menuMode = MENU_NORMAL;
  protected int currentImageFileNameIndex = 0;
  protected Image currentFileImage = null;
  protected Image netImage = null;
  protected final int DRAW_FILE = 0, DRAW_NET = 1;
  protected int drawMode = DRAW_FILE;
  protected boolean magFlag = false;
  protected String[] imageFileNameList = null;
  protected Font font = null;
  protected String helpString1 = 
    "J[\ړL[\n" +
    "@ ... 1ÕLv`ʂ\\n" +
    "@E ... 1̃Lv`ʂ\\n" +
    "@Shift+ ... ŏ̃Lv`ʂ\\n" +
    "@Shift+E ... Ō̃Lv`ʂ\\n" +
    "}EXhbO ... \ĂLv`ʂȂǂ̕\ʒuύX\n" +
    "A ... \ĂLv`ʂȂǂ̈ʒuɖ߂\n" +
    "M ... Mag \ĂLv`ʂȂǂg/k\n";
  protected String helpString2 = 
    "H ... Help wv\\n" +
    "ESC ... Escape I\n";
  protected String helpString = helpString1 + helpString2;
  
  public BaseCanvas(Snapshot _snapshot) throws Exception{
    try{
      snapshot = _snapshot;
      imageDir = snapshot.ini.getCaptureDir();
      addKeyListener(this);
      addMouseListener(this);
      addMouseMotionListener(this);
      setBackground(Color.WHITE);
      setForeground(Color.BLACK);
      font = new Font(Font.MONOSPACED, Font.PLAIN, 24);
      setFont(font);
      makeImageFileNameList();
      if(imageFileNameList.length > 0)
        getCurrentImageFromFile();
      setVisible(true);
    }catch(Exception e){
      C.throwException("Base: Base:", e.toString());
    }
  }

  void getCurrentImageFromFile(){
    currentFileImage = snapshot.toolkit.getImage(imageDir + "\\" + imageFileNameList[currentImageFileNameIndex]);
  }

  void prevImage(){
    if(imageFileNameList.length == 0)
      return;
    currentImageFileNameIndex--;
    if(currentImageFileNameIndex < 0)
      currentImageFileNameIndex = imageFileNameList.length -1;
    getCurrentImageFromFile();
  }

  void nextImage(){
    if(imageFileNameList.length == 0)
      return;
    currentImageFileNameIndex++;
    if(currentImageFileNameIndex >= imageFileNameList.length)
      currentImageFileNameIndex = 0;
    getCurrentImageFromFile();
  }
 
  void firstImage(){
    if(imageFileNameList.length == 0)
      return;
    currentImageFileNameIndex = 0;
    getCurrentImageFromFile();
  }

  void lastImage(){
    makeImageFileNameList();
    if(imageFileNameList.length == 0)
      return;
    currentImageFileNameIndex = imageFileNameList.length -1;
    getCurrentImageFromFile();
  }

  void makeImageFileNameList(){
    File[] fa = (new File(imageDir)).listFiles();
    int i = 0, n = 0;
    for(i = 0; i < fa.length; i++)
      if(fa[i].getName().endsWith("." + Snapshot.IMAGE_TYPE))
        n++;
    imageFileNameList = new String[n];
    n = 0;
    for(i = 0; i < fa.length; i++){
      String s = fa[i].getName();
      if(s.endsWith("." + Snapshot.IMAGE_TYPE))
        imageFileNameList[n++] = s;
    }
    if(n != imageFileNameList.length)
      C.error("BaseCanvas: makeImageFileNameList: n != imageFileNameList.length: "
              + n + "," + imageFileNameList.length);
    Arrays.sort(imageFileNameList);
  }

  public void paintNormal(Graphics g){
    switch(drawMode){
    case DRAW_FILE:
      if(currentFileImage != null){
        snapshot.setTitle("t@C{ " + imageFileNameList[currentImageFileNameIndex]);
        if(!magFlag)
          g.drawImage(currentFileImage, drawX, drawY, this);
        else
          g.drawImage(currentFileImage, drawX, drawY,
                      currentFileImage.getWidth(this) *2, currentFileImage.getHeight(this) *2, Color.BLACK, this);
      }else{
        snapshot.setTitle("t@C{ {t@C");
      }
      break;
    case DRAW_NET:
      if(netImage != null){
        snapshot.setTitle("M ");
        if(!magFlag)
          g.drawImage(netImage, drawX, drawY, this);
        else
          g.drawImage(netImage, drawX, drawY,
                      netImage.getWidth(this) *2, currentFileImage.getHeight(this) *2, Color.BLACK, this);
      }else{
        snapshot.setTitle("M M摜");
      }
      break;
    }
  }

  void viewHelp(){
    JOptionPane.showMessageDialog(null, helpString, "wv", JOptionPane.PLAIN_MESSAGE);
  }

  void paintUserId(Graphics g){}

  public void paint(Graphics g){
    switch(menuMode){
    case MENU_NORMAL: paintNormal(g); break;
    case MENU_USERID: paintUserId(g); break;
    }
  }

  public void update(Graphics g){
    if(canvasClearFlag)
      g.clearRect(0, 0, (int)(snapshot.windowSize.getWidth()), (int)(snapshot.windowSize.getHeight()));
    paint(g);
  }

  public void keyReleasedNormal(int key, int modifiers){
    int shift = KeyEvent.SHIFT_DOWN_MASK;
    switch(key){
    case KeyEvent.VK_LEFT:
      drawMode = DRAW_FILE;
      if((modifiers & shift) == shift)
        firstImage();
      else
        prevImage();
      repaint();
      break;
    case KeyEvent.VK_RIGHT:
      drawMode = DRAW_FILE;
      if((modifiers & shift) == shift)
        lastImage();
      else
        nextImage();
      repaint();
      break;
    case KeyEvent.VK_A: drawX = 0; drawY = 0; repaint(); break;
    case KeyEvent.VK_M: magFlag = !magFlag; repaint(); break;
    case KeyEvent.VK_H: viewHelp(); break;
    case KeyEvent.VK_ESCAPE:
      if(C.confirm("ȈɂȂ邩܂񂪁A" + C.cr + "{ɏI܂H")){
        C.d("BaseCanvas: KeyReleasedNormal: VK_ESCAPE: end");
        snapshot.exit();
      } break;
    }
  }

  void keyReleasedUserId(int key, int modifiers){}

  void keyReleased(int key, int modifiers){
    switch(menuMode){
    case MENU_NORMAL:
      keyReleasedNormal(key, modifiers);
      break;
    case MENU_USERID: 
      keyReleasedUserId(key, modifiers);
      break;
    }
  }

  public void keyReleased(KeyEvent e){
    keyReleased(e.getKeyCode(), e.getModifiersEx());
  }
  public void keyTyped(KeyEvent e){}
  public void keyPressed(KeyEvent e){}

  public void mousePressedUserId(){}

  public void mousePressed(MouseEvent e){
    switch(e.getButton()){
    case MouseEvent.BUTTON1:
      mouseX = e.getX();
      mouseY = e.getY();
      mousePressedUserId();
      break;
    }
  }
  public void mouseClicked(MouseEvent e){}
  public void mouseReleased(MouseEvent e){}
  public void mouseEntered(MouseEvent e){}
  public void mouseExited(MouseEvent e){}

  public void mouseDragged(MouseEvent e){
    int x = e.getX(), y = e.getY();
    drawX += (x - mouseX); mouseX = x;
    drawY += (y - mouseY); mouseY = y;
    repaint();
  }
  public void mouseMoved(MouseEvent e){}

}
