/*
Copyright (C) 2012-2013 Taisuke Kobayashi
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
import java.net.DatagramSocket;

class Client implements Runnable {

  private Snapshot snapshot;
  private ClientCanvas clientCanvas;
  FileCom fileCom = null;
  FileComImage fileComImage = null;
  private DatagramSocket dsCheckDummy;
  SeatDialog seat;
  private boolean writeTempFileFlag = false;
  private final int sleepPeriod = 100;
  private final int sleepCountNum = 1*10; // 1b
  private int sleepCount = 0;

  public Client(Snapshot _snapshot) throws Exception{
    try{
      snapshot = _snapshot;
      try{
        dsCheckDummy =  new DatagramSocket(snapshot.ini.getUdpPortForCheck());
      }catch(Exception e){
        C.error("Client: Client: ɋNĂ܂B" + e.toString());
        C.exit();
      }
      clientCanvas = new ClientCanvas(snapshot);
      fileCom = new FileCom(snapshot);
      fileComImage = new FileComImage(snapshot);
      C.info("ƏI܂ŋN܂܂ɂĉB\nwvHL[łB" +
             "\n\nɒȂȂ̔ԍ͂܂B\n̉ʂŁAȔԍIAOKĉB");
      seat = new SeatDialog(snapshot);
      seat.select();
      fileCom.writeSeat(seat.get());
      new Thread(this).start();
    }catch(Exception e){
      C.throwException("Client: Client:", e);
    }
  }

  public ClientCanvas getClientCanvas(){ return clientCanvas; }

  public void run(){
    try{
      while(true){
        if(writeTempFileFlag){
          snapshot.capture();
          fileComImage.writeTempFile();
        }
        if(++sleepCount > sleepCountNum){
          sleepCount = 0;
          doJunkaiCommandT();
          checkReceiveCommandT();
        }
        Thread.sleep(sleepPeriod);
      }
    }catch(Exception e){
      C.error("Client: run:" + C.cr + e.toString());
    }
  }

  void checkReceiveCommandT() throws Exception{
    try{
      String c = fileComImage.getReceiveCommand(), u = snapshot.userId;
      if(c.indexOf(u) != -1){
        if(writeTempFileFlag == false){
          fileCom.writeReceive();
          fileComImage.deleteTempFiles();
          writeTempFileFlag = true;
        }
      }else{
        writeTempFileFlag = false;
      }
    }catch(Exception e){
      writeTempFileFlag = false;
      C.throwException("Client: checkReceiveCommandT: ", e);
    }
  }

  void doJunkaiCommandT() throws Exception{
    try{
      String c = fileComImage.getJunkaiCommand(), u = snapshot.userId;
      if(c.indexOf(u) != -1){
        snapshot.getMousePointForCapture();
        snapshot.capture();
        fileComImage.writeJunkaiFile(u);
        fileCom.writeAck();
      }
    }catch(Exception e){
      C.throwException("Client: doCommandT: ", e);
    }
  }

}
