/*
Copyright (C) 2012-2013 Taisuke Kobayashi
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
import java.awt.Frame;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SeatDialog extends JDialog implements ActionListener {

  SeatPanel seat;
  
  public SeatDialog(Frame _owner){
    super(_owner, "ȔԍI", true);
    setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
    setLayout(new BorderLayout());
    add(new JLabel("ȂȔԍIĉB"), BorderLayout.NORTH);
    seat = new SeatPanel();
    add(seat, BorderLayout.CENTER);
    JButton ok = new JButton("OK");
    add(ok, BorderLayout.SOUTH);
    ok.addActionListener(this);
    setSize(800, 600);
  }

  public String get(){
    ButtonModel bm = seat.group.getSelection();
    if(bm == null)
      return "ng";
    return bm.getActionCommand();
  }

  public void select(){
    seat.group.clearSelection();
    setVisible(true);
  }

  public void actionPerformed(ActionEvent e){
    if(seat.group.getSelection() == null){
      C.info("ȔԍIOK{^NbNĉB");
      return;
    }
    setVisible(false);
  }
  
  class SeatPanel extends JPanel{
    ButtonGroup group;

    SeatPanel(){
      group = new ButtonGroup();
      setLayout(new GridLayout(8, 10));
      for(int i = 1; i <= 80; i++){
        String s = String.format("%02d", i);
        JRadioButton rb = new JRadioButton(s);
        rb.setActionCommand(s);
        add(rb);
        group.add(rb);
      }
    }
  }

}
