/*
Copyright (C) 2012-2013 Taisuke Kobayashi
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
import java.io.File;
import java.io.FileWriter;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ServerCanvas extends BaseCanvas {

  private final int Ulw = 300, Ulp = 2, Uln = 18;
  private int sortMode = ClientList.SORT_MODE_USERID;
  private int currentUserIdIndex = 0;
  private String[] userList = null;
  private String helpStringNormal =
    "Xy[XL[ ... wʂɐ؂ւ\n" +
    "                 M̎́AM~At@C{\ɂĂA؂ւ\n" +
    "R ... Receive M~\n" +
    "J ... Junkai Jn܂͒~\n" +
    "F ... File/Net t@C{ƁAM̕\ؑւ\n" +
    "               M̎́AM~At@C{\ɂ\n" +
    "C ... Capture ɉʃLv`\n" +
    "W ... Wait 7bɉʃLv`\n" +
    "J[\L[ ... EBhȆ傫ő剻\n" +
    "J[\L[ ... EBhȆ傫ɖ߂\n";
  private String helpStringUserId =
    "Xy[XL[ ... 摜\ʂɖ߂\n" +
    "S ... Sort wIDƐȔԍ̕בւ\n" +
    "R ... Receive MJn܂͒~\n" +
    "              Iw̉ʂM\n" +
    "              Jn̎́AIɉ摜\ʂɖ߂\n" +
    "              ~̎́A摜\ʂt@C{\ɂ\n" +
    "C ... Capture ɉʃLv`\n" +
    "K ... Keep ŏɂɉʃLv`\n" +
    "Shift+S ... Save oȃt@C\n" +
    "J[\L[ ... wI邽߂ɏ㉺EɈړ\n" +
    "}EXNbN ... wI\n";

  public ServerCanvas(Snapshot _snapshot) throws Exception{
    super(_snapshot);
  }

  public void capture(int mode){
    switch(mode){
    case 0:
      snapshot.getMousePointForCapture();
      snapshot.setExtendedState(JFrame.ICONIFIED);
      C.sleep(100);
      break;
    case 1:
      break;
    case 2:
      snapshot.setExtendedState(JFrame.ICONIFIED);
      if(!C.confirm("7bɉʂLv`܂B" + C.cr + "͂ł܂H")){
        C.info("ʂLv`܂łB");
        return;
      }
      C.sleep(7*1000);
      snapshot.getMousePointForCapture();
      break;
    }
    snapshot.server.captureAndSave();
    lastImage();
    drawMode = DRAW_FILE;
    snapshot.setExtendedState(JFrame.MAXIMIZED_BOTH);
  }

  String userInfo(int mode, int index){
    if(userList == null)
      return "";
    switch(sortMode){
    case ClientList.SORT_MODE_USERID: return userInfoUserId(mode, index);
    case ClientList.SORT_MODE_SEATNO: return userInfoSeatNo(mode, index);
    }
    return "";
  }

  String userInfoUserId(int mode, int index){
    String ret = "";
    String[] sa = userList[index].split(ClientList.FIELD_SEP);
    switch(mode){
    case 0:
      //if(sa[0].length() < 3) ret += sa[0];
      //else ret += sa[0].substring(1, sa[0].length() -1);
      ret += sa[0];
      for(int i = 1; i < sa.length; i++)
        ret += ClientList.FIELD_SEP + sa[i];
      break;
    case 1:
      ret += sa[1] + " ";
      //if(sa[0].length() < 3) ret += sa[0];
      //else ret += sa[0].substring(1, sa[0].length() -1);
      ret += sa[0];
      if(sa.length > 2){
        ret += " ";
        switch(sa[2].length()){
        case 0: ret += "@@@"; break;
        case 1: ret += sa[2] + "@@"; break;
        case 2: ret += sa[2] + "@"; break;
        default: ret += sa[2].substring(0, 3); break;
        }
      }
      // if(sa.length > 6) ret += " " + sa[6];
      if(sa.length > 6) ret += " " + sa[sa.length -1];
      break;
    case 2:
      ret = sa[0];
      break;
    case 3:
      ret = sa[sa.length -1];
      ret = ret.substring(ret.length() -1);
      break;
    }
    return ret;
  }

  String userInfoSeatNo(int mode, int index){
    String ret = "";
    String[] sa = userList[index].split(ClientList.FIELD_SEP);
    switch(mode){
    case 0:
      ret += sa[0] + ClientList.FIELD_SEP;
      //if(sa[1].length() < 3) ret += sa[1];
      //else ret += sa[1].substring(1, sa[1].length() -1);
      ret += sa[1];
      for(int i = 2; i < sa.length; i++)
        ret += ClientList.FIELD_SEP + sa[i];
      break;
    case 1:
      ret += sa[0] + " ";
      //if(sa[1].length() < 3) ret += sa[1];
      //else ret += sa[1].substring(1, sa[1].length() -1);
      ret += sa[1];
      if(sa.length > 2){
        ret += " ";
        switch(sa[2].length()){
        case 0: ret += "@@@"; break;
        case 1: ret += sa[2] + "@@"; break;
        case 2: ret += sa[2] + "@"; break;
        default: ret += sa[2].substring(0, 3); break;
        }
      }
      // if(sa.length > 6) ret += " " + sa[6];
      if(sa.length > 6) ret += " " + sa[sa.length -1];
      break;
    case 2:
      ret = sa[1];
      break;
    case 3:
      ret = sa[sa.length -1];
      ret = ret.substring(ret.length() -1);
      break;
    }
    return ret;
  }

  void paintUserId(Graphics g){
    FontMetrics fm = g.getFontMetrics();
    int fh = fm.getHeight(), fd = fm.getDescent();
    snapshot.setTitle("wI");
    String s = "" + userList.length + " l ";
    g.drawString(s, Ulp, fh + Ulp - fd);
    g.drawString(userInfo(0, currentUserIdIndex), Ulp + fm.stringWidth(s), fh + Ulp - fd);
    for(int i = 0; i < userList.length; i++){
      if(userInfo(3, i).charAt(0) == FileCom.MESSAGE_TYPE_DOWN) g.setColor(Color.RED);
      g.drawString(userInfo(1, i), (i / Uln) * (Ulw + Ulp *2) + Ulp, ((i % Uln) +1 +1)  * (fh + Ulp *2) - fd - Ulp);
      g.setColor(Color.BLACK);
    }
    g.drawRect((currentUserIdIndex / Uln) * (Ulw + Ulp *2) + Ulp,
               (currentUserIdIndex % Uln +1) * (fh + Ulp *2) + Ulp, Ulw - Ulp *2, fh - Ulp *2);
  }

  public void mousePressedUserId(){
    if((userList == null) || (font == null))
      return;
    int h = getFontMetrics(font).getHeight() + Ulp *2;
    if(mouseY >= h){
      int i = (mouseX / Ulw) * Uln + (mouseY - h) / h;
      if(i < userList.length){
        currentUserIdIndex = i;
        repaint();
      }
    }
  }

  public void keyReleasedUserId(int key, int modifiers){
    int shift = KeyEvent.SHIFT_DOWN_MASK;
    int len = userList.length;
    switch(key){
    case KeyEvent.VK_H: case KeyEvent.VK_ESCAPE: keyReleasedNormal(key, modifiers); break;
    case KeyEvent.VK_SPACE:
      menuMode = MENU_NORMAL;
      canvasClearFlag = false;
      break;
    case KeyEvent.VK_S:
      if((modifiers & shift) == shift){
        if(C.confirm("{ɏoȃt@Cɏ݂܂H"))
          writeUserListFile();
      }else{
        sortMode++;
        if(sortMode > ClientList.SORT_MODE_SEATNO)
          sortMode = ClientList.SORT_MODE_USERID;
        if(snapshot.server.fileCom != null)
          snapshot.server.fileCom.read();
        userList = snapshot.server.clientList.getUserList(sortMode);
        repaint();
      }
      break;
    case KeyEvent.VK_R:
      if(snapshot.server.receiveToggle(userInfo(2, currentUserIdIndex))){
        menuMode = MENU_NORMAL;
        canvasClearFlag = false;
        drawMode = DRAW_NET;
        C.info("MJn܂B");
      }else{
        drawMode = DRAW_FILE;
        C.info("M~܂B");
      }
      repaint();
      break;
    case KeyEvent.VK_C: capture(0); repaint(); break;
    case KeyEvent.VK_K: capture(1); repaint(); break;
    case KeyEvent.VK_UP:
      currentUserIdIndex--;
      if(currentUserIdIndex < 0)
        currentUserIdIndex = len -1;
      break;
    case KeyEvent.VK_DOWN:
      currentUserIdIndex++;
      if(currentUserIdIndex >= len)
        currentUserIdIndex = 0;
      break;
    case KeyEvent.VK_LEFT:
      currentUserIdIndex -= Uln;
      if(currentUserIdIndex < 0){
        currentUserIdIndex += (len / Uln +1) * Uln;
        if(currentUserIdIndex >= len)
          currentUserIdIndex = len -1;
        if(currentUserIdIndex < 0)
          currentUserIdIndex = 0;
      }
      break;
    case KeyEvent.VK_RIGHT:
      currentUserIdIndex += Uln;
      if(currentUserIdIndex >= len){
        currentUserIdIndex -= (len / Uln +1) * Uln;
        if(currentUserIdIndex >= len)
          currentUserIdIndex = len -1;
        if(currentUserIdIndex < 0)
          currentUserIdIndex = 0;
      }
      break;
    }
    repaint();
  }

  public void keyReleasedNormal(int key, int modifiers){
    switch(key){
    case KeyEvent.VK_ESCAPE:
      if(C.confirm("{ɏI܂H")){
        if(C.confirm("IƏoȏ͔j܂B" + C.cr
                     + "oȃt@Cɏ݂܂H")){
          writeUserListFile();
        }
        try{
          snapshot.server.fileComImage.setJunkaiCommand("");
        }catch(Exception e){
          C.e("ServerCanvas: KeyReleasedNormal: VK_ESCAPE: fileComImage.setJunkaiCommand");
        }
        C.d("ServerCanvas: KeyReleasedNormal: VK_ESCAPE: end");
        C.exit();
      }
      break;
    case KeyEvent.VK_SPACE:
      if(snapshot.server.receiveOff()){
        drawMode = DRAW_FILE;
        C.info("M~܂B");
      }
      snapshot.server.fileCom.read();
      userList = snapshot.server.clientList.getUserList(sortMode);
      if(userList == null){
        C.info("[Uo^Ă܂B");
        break;
      }
      menuMode = MENU_USERID;
      canvasClearFlag = true;
      repaint();
      break;
    case KeyEvent.VK_R:
      if(snapshot.server.receiveOff()){
        drawMode = DRAW_FILE;
        repaint();
        C.info("M~܂B");
      }else{
        C.info("M͊ɒ~Ă܂B");
      }
      break;
    case KeyEvent.VK_J:
      if(snapshot.server.junkaiToggle())
        C.info("ĊJ܂B");
      else
        C.info("𒆎~܂B");
      break;
    case KeyEvent.VK_F:
      if(snapshot.server.receiveOff()){
        drawMode = DRAW_FILE;
        C.info("M~܂B");
      }else{
        switch(drawMode){
        case DRAW_FILE: drawMode = DRAW_NET; break;
        case DRAW_NET: drawMode = DRAW_FILE; break;
        }
      } repaint(); break;
    case KeyEvent.VK_C: capture(0); repaint(); break;
    case KeyEvent.VK_W: capture(2); repaint(); break;
    case KeyEvent.VK_UP: snapshot.setExtendedState(JFrame.MAXIMIZED_BOTH); repaint(); break;
    case KeyEvent.VK_DOWN: snapshot.setExtendedState(JFrame.NORMAL); repaint(); break;
    default: super.keyReleasedNormal(key, modifiers); break;
    }
  }

  void viewHelp(){
    switch(menuMode){
    case MENU_NORMAL:
      JOptionPane.showMessageDialog(null, helpString + helpStringNormal, "wv", JOptionPane.PLAIN_MESSAGE);
      break;
    case MENU_USERID:
      JOptionPane.showMessageDialog(null, helpString2 + helpStringUserId, "wv", JOptionPane.PLAIN_MESSAGE);
      break;
    }
  }

  void writeUserListFile(){
    if(snapshot.server.fileCom != null)
      snapshot.server.fileCom.read();
    userList = snapshot.server.clientList.getUserList(ClientList.SORT_MODE_USERID);
    if(userList == null){
      C.info("[Uo^Ă܂B");
      return;
    }
    String path = snapshot.ini.getShussekiFilePath();
    try{
      File f = new File(path);
      f.setWritable(true);
      FileWriter fw = new FileWriter(f, true);
      String ts = C.getCustomDateTimeString(C.CUSTOM_DATE_TIME_COMMA) + ",", s = "";
      for(int i = 0; i < userList.length; i++){
        s = ts + userList[i] + C.cr;
        fw.write(s, 0, s.length());
      }
      fw.close();
      f.setWritable(false);
    }catch(Exception e){
      C.e("ServerCanvas: writeUserListFile: 1: " + e.toString());
      C.info("t@C " + path + " ɐɏ݂ł܂łB");
      return;
    }
    try{
      Runtime.getRuntime().exec("notepad.exe " + path);
    }catch(Exception e){
      C.e("ServerCanvas: writeUserListFile: 2: " + e.toString());
      C.info("notepad.exeNł܂łB");
    }
  }

  public void readAndPaintNetImage(String path){
    netImage = snapshot.toolkit.getImage(path);
    repaint();
  }

}
