/*
Copyright (C) 2012-2013 Taisuke Kobayashi
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.io.BufferedReader;
import java.io.FileReader;

class UserList {

  private HashMap<String, String> userIdMap;

  public UserList(String userListFilePath) throws Exception{
    try{
      userIdMap = new HashMap<String, String>();
      makeUserIdMap(userListFilePath);
    }catch(Exception e){
      C.throwException("UserList: UserList:", e);
    }
  }

  public String get(String key){
    String s = userIdMap.get(key);
    if(s == null) s = "";
    return s;
  }
  
  void makeUserIdMap(String path) throws Exception{
    try{
      FileReader fr = new FileReader(path);
      BufferedReader br = new BufferedReader(fr);
      String line;
      Pattern p = Pattern.compile("^([^,]+),(.+)$");
      while((line = br.readLine()) != null){
        Matcher m = p.matcher(line);
        if(m.find())
          userIdMap.put(C.getStudentNo(m.group(1)), m.group(2).replaceAll("[ @]", ""));
      }
      br.close();
      fr.close();
    }catch(Exception e){
      C.throwException("UserList: makeUserIdMap:", e);
    }
  }

}
