<?php
/*++++++++++++++++++++++++++++++++++++++++++++++++++++
| LightNEasy Content Management System
| Copyright 2007 - 2009 Fernando Baptista
| http://Lightneasy.org
++++++++++++++++++++++++++++++++++++++++++++++++++++++
| lightneasy.php main file
| no database version 2.3
++++++++++++++++++++++++++++++++++++++++++++++++++++++
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
session_start();
clearstatcache();
error_reporting(E_ERROR | E_WARNING | E_PARSE);

// Redirects to install.php if data files don't exist
if(!file_exists("./data/config.php")) header ("Location: ./LightNEasy/install.php");

// Detects the insertion of code in the $_GET array
foreach ($_GET as $check_url) {
	if ((eregi("<[^>]*script*\"?[^>]*>", $check_url)) || (eregi("<[^>]*object*\"?[^>]*>", $check_url)) || (eregi("<[^>]*iframe*\"?[^>]*>", $check_url)) || (eregi("<[^>]*applet*\"?[^>]*>", $check_url)) || (eregi("<[^>]*meta*\"?[^>]*>", $check_url)) || (eregi("<[^>]*style*\"?[^>]*>", $check_url)) || (eregi("<[^>]*form*\"?[^>]*>", $check_url)) || (eregi("\([^>]*\"?[^)]*\)", $check_url)) || (eregi("\"", $check_url))) die ("Hijacking attempt, dying....");
}
unset($check_url);

// Installs the common functions
require_once "LightNEasy/common.php";

$set = array();
readsetup();
if($set['language']=="") $set['language']="en_US";
if($set['langeditor']=="") $set['langeditor']="en";

if (!eregi($set['indexfile'], sv('PHP_SELF')) && !eregi('index.php', sv('PHP_SELF')))
	die ('Access Denied!');

// Checks if there was a login attempt
if($_GET['do']=="login") {
	if(sha1(trim($_POST['password']))==$set['password']) {
		$_SESSION[$set['password']]="1";
		$message=$langmessage[95];
		unset($_GET['do']);
	} else $message=$langmessage[96];
}

// Disables $_GET and $_POST if the user is not logged in, except for the allowed posts

// Disables $_GET except for login and sitemap
if($_GET['do']!="login" && $_GET['do']!="sitemap" && $_SESSION[$set['password']] != "1") unset($_GET['do']);

// Disables $_POST['submit'] except for login, send message and send comment
if($_POST['submit']!="login" && $_POST['submit']!="Send message" && $_POST['submit']!="sendcomment" && $_SESSION[$set['password']] != "1") unset($_POST['submit']);

### LightNEay global variables: ###
// $set - settings
// $langmessage - the language file
// $message - general messages to the user

// Global variable containing messages to the user;
$message="";

// edit these 2 following values to your convenience
$max_upload_file_size=2000000;
$max_upload_image_size=250000;

// $menu - contains the menu
$menu=array(array('m1','m2','m3','link','name','descr','templ'));

// $selected - contains the information of the current page
$selected=array('index','m2','m3','link','name','descr','templ');

// $pagenum - the file name of the current page
$pagenum=sanitize($_GET['page']);
if($pagenum=="") $pagenum="index";

// $out - String containing the page to be sent to the browser
$out="";

### End of global variables ###

### Treat posts and other inputs ###
if(isset($_GET['dlid'])) {
	$message = senddownload();
}


switch($_POST['submit']) {
	case "sendcomment":
		$message = sendcomment();
		break;
	case "Send message":
		$message = sendmessage();
		break;
	case "login":
		if(sha1(trim($_POST['password']))==$set['password']) {
			$_SESSION[$set['password']]=1;
			unset($_GET['do']);
			$message=$langmessage[95];
		} else
			$message=$langmessage[96];
	default:
}

// Read the menu
readmenu();

// reads the admin functions if the user is logged in
if($_SESSION[$set['password']] == "1") {
	require_once "./LightNEasy/admin.php";
//call admin functions for treating inputs if logged in
	treat_posts();
}

if($selected['templ'] != "-")
	$templatepath="./templates/".$selected['templ']."/template.php";
else
	$templatepath="./templates/".$set['template']."/template.php";
if (!file_exists($templatepath)) $templatepath="./templates/lightneasy/template.php";
if (!file_exists($templatepath)) die ($templatepath." ".$langmessage[109]);

if($_GET['do']=="generate") generate();
//if($_GET['do']=="generate") $message="Function disabled";

### Create page for display ###

//Display the template and call the embebbed functions
$page=file_get_contents($templatepath);
$out="";
while($page != "") {
	if($pagearray=explode($set['openfield'],stripslashes($page),2)) {
		$out.=$pagearray[0];
		$page=$pagearray[1];
		if($pagearray=explode($set['closefield'],$page,2)) {
			$command=trim($pagearray[0]);
			$page=$pagearray[1];
			switch($command) {
				case "header": $out.=printheader(0); break;
				case "title": $out.='<a href="'.$set['homepath'].'">'.$set['title'].'</a>'; break;
				case "subtitle": $out.=$set['subtitle']; break;
				case "content": content(); break;
				case "homelink": $out.='<a href="'.$set['homepath'].'">Home</a>'; break;
				case "image": $out.="./templates/".$set['template']."/images/"; break;
				case "mainmenu": $out.= mainmenu(0); break;
				case "mainmenu1": $out.= mainmenu(0,1); break;
				case "mainmenu2": $out.= mainmenu(0,2); break;
				case "treemenu": $out.=treemenu(0); break;
				case "submenu": $out.=submenu(0); break;
				case "fullmenu": $out.= fullmenu(0); break;
				case "expmenu": $out.= expmenu(0); break;
				case "sitemap": $out.= sitemap(0); break;
				case "selected": $out.= $selected['name']; break;
				case "login": loginout(); break;
				case "extra": extra(); break;
				case "links": $out.=show(0,"link"); break;
				case "downloads": $out.=show(0,"download"); break;
				case "lastnews": $out.=lastnews(); break;
				case "footer": $out.= $set['footer']; break;
				default: 
					if(strpos($command, "content")!== false) {
						$aa=explode(" ",$command,2);
						showcontent($pagenum, "data/".$pagenum."_".$aa[1].".html");
					} elseif(strpos($command, "plugin")!== false) {
						$aa=explode(" ",$command,2);
						$pluginpath="plugins/".trim($aa[1]);
						if(file_exists($pluginpath."/first.mod"))
							$out=file_get_contents($pluginpath."/first.mod").$out;
						if(file_exists($pluginpath."/header.mod"))
							$out=str_replace("</head>",file_get_contents($pluginpath."/header.mod")."\n</head>",$out);
						if(file_exists($pluginpath."/onload.mod"))
							$out=str_replace("<body","<body onload=\"".file_get_contents($pluginpath."/onload.mod")."\"",$out);
						if(file_exists($pluginpath."/include.mod"))
							include "plugins/".trim($aa[1])."/include.mod";
						if(file_exists($pluginpath."/place.mod"))
							$out.=file_get_contents("$pluginpath/place.mod");
					} elseif(strpos($command, "lastnews")!== false) {
						$aa = explode(" ",$command,2);
						$out .= lastnews($aa[1]);
					} elseif(strpos($command, "plugin")!== false) {
						$aa=explode(" ",$command,2);
						$pluginpath="plugins/".trim($aa[1]);
						if(file_exists($pluginpath."/first.mod"))
							$out=file_get_contents($pluginpath."/first.mod").$out;
						if(file_exists($pluginpath."/header.mod"))
							$out=str_replace("</head>",file_get_contents($pluginpath."/header.mod")."\n</head>",$out);
						if(file_exists($pluginpath."/onload.mod"))
							$out=str_replace("<body","<body onload=\"".file_get_contents($pluginpath."/onload.mod")."\"",$out);
						if(file_exists($pluginpath."/include.mod"))
							include "plugins/".trim($aa[1])."/include.mod";
						if(file_exists($pluginpath."/place.mod"))
							$out.=file_get_contents("$pluginpath/place.mod");
					} elseif(strpos($command, "links")!== false)
						$out.=show(trim(substr($command,5)),"link");
					elseif(strpos($command, "downloads")!== false)
						$out.=show(trim(substr($command,9)),"download");
					else
						$out.=$command;
			}
		} else break;
	} else break;
}
if($page != "") $out.=$page;

// finished page creation, send it to the browser
print $out;

### Execution end ###

function content() {
  global $pagenum,$edit,$set,$selected,$message,$menu,$out,$langmessage, $LNEversion, $message;
  if($message!="") $out.="<h2 class=\"LNE_message\">".$message."</h2>\n";
  if(function_exists('adminmenu')) $out.=adminmenu();
	switch($_GET['do']) {
	case "plugins":
		$out.=plugins();
		break;
	case "download":
		$out.="<h2 class=\"LNE_title\">$langmessage[48]</h2>\n";
		$out.="<div align=\"center\">\n<h3>$langmessage[49]</h3>\n";
		edit("download");
		break;
	case "editlinks":
		$out.="<h2 class=\"LNE_title\">$langmessage[40]</h2>\n";
		$out.="<div align=\"center\">\n<h3>$langmessage[66]</h3>\n";
		edit("link");
		break;
	case "sitemap":
		$out.="<h2 class=\"LNE_title\">$langmessage[88]</h2>\n<p><ul>";
		$out.=fullmenu(0);
		$out.="</ul></p>";
		break;
	case "edit":
		print $out;
		$out="";
		editpage($pagenum);
		break;
	case "editextra":
		print $out;
		$out="";
		editextra();
		break;
	case "login":
		$out.= loginform();
		break;
	case "image":
		$out.= images();
		break;
	case "settings":
		$out.= settings();
		break;
	case "setup":
		$out.= setup();
		break;
	case "editmenu":
		$out.= editmenu();
		break;
	case "delete":
		deleteform();
		break;
	case "create":
		$out.= createform();
		break;
	case "adminnews":
		print $out;
		$out="";
		adminnews();
		break;
	default:
		if(!file_exists("./data/".$pagenum.".html")) {
			$achou=false;
			foreach($menu as $men) {
				if($men[3]==$pagenum) {
					$achou=true;
					break;
				}
			}
			if($achou) {
				$fp=fopen("./data/".$pagenum.".html","w");
				fwrite($fp,"<h1 class=\"LNE_title\">".$men['4']."</h1>\n");
				fclose($fp);
				$fp=fopen("./data/pages.dat","a");
				fwrite($fp,encode($pagenum."|-|-||"));
				fclose($fp);
				$out.=showcontent($pagenum);
			} else
				$out.="<h2>".$langmessage[116]."</h2>\n";
		} else
			$out.=showcontent($pagenum);
	}
}

function extra() {
	global $out;
	if(file_exists("data/extra.htm")) $out.=showcontent($pagenum,"extra.htm");
}

function showcontent($pagenum,$file="") {
	global $out;
	$open="%!$";
	$close="$!%";
	if($file=="")
		$page=stripslashes(file_get_contents("data/".$pagenum.".html"));
	else
		if(file_exists("data/".$file))
			$page=stripslashes(file_get_contents("data/".$file));
		else 
			$page="<h2>$langmessage[116]</h2>\n";
	while(strpos($page,$open)) {
		$pagearray=explode($open,$page,2);
		$out.=$pagearray[0];
		unset($pagearray1);
		$pagearray1=explode($close,$pagearray[1],2);
		if(substr($pagearray1[0],0,7)=="include") {
			print $out;
			$out="";
			include(trim(substr($pagearray1[0],7)));
		} elseif(substr($pagearray1[0],0,7)=="wrapper") {
			$bb=trim(substr($pagearray1[0],7));
			$aa=explode(" ",$bb);
			$out=str_replace("</head>","<script language=\"JavaScript\">\n<!--\nfunction calcHeight()\n{\n\t//find the height of the internal page\n\tvar the_height=document.getElementById('the_iframe').contentWindow.document.body.scrollHeight+4;\n\t//change the height of the iframe\n\tdocument.getElementById('the_iframe').height=the_height;\n}\n//-->\n</script>\n</head>",$out);
			$framewidth=0;
			if($aa[1]!="") $framewidth=strval(trim($aa[1]));
			$out.=iframe($aa[0],$framewidth);
		} elseif(substr($pagearray1[0],0,8)=="function") {
			$bb=trim(substr($pagearray1[0],8));
			$aa=explode(" ",$bb);
			if($aa[3]!="") $out.=$aa[0]($aa[1],$aa[2],$aa[3]);
			elseif($aa[2]!="") $out.=$aa[0]($aa[1],$aa[2]);
			elseif($aa[1]!="") $out.=$aa[0]($aa[1]);
			else $out.=$aa[0]();
		} elseif(substr($pagearray1[0],0,7)=="contact") $out.= contact();
		elseif($pagearray1[0]=="links") $out.= show(0,"link");
		elseif($pagearray1[0]=="news") $out.= shownews();
		elseif(substr($pagearray1[0],0,5)=="links") $out.= show(trim(substr($pagearray1[0],5)),"link");
		elseif($pagearray1[0]=="downloads") $out.= show(0,"download");
		elseif(substr($pagearray1[0],0,9)=="downloads") $out.= show(trim(substr($pagearray1[0],0,9)),"download");
		elseif(substr($pagearray1[0],0,6)=="galery") {
			$out=str_replace("</head>","<link rel=\"stylesheet\" href=\"css/lytebox.css\" type=\"text/css\" media=\"screen\" />\n<script type=\"text/javascript\" src=\"js/lytebox.js\"></script>\n</head>",$out);
			if(trim($pagearray1[0])=="galery") $out.=galery();
			else $out.=galery(trim(substr($pagearray1[0],7)));
		} elseif(substr($pagearray1[0],0,9)=="lyteframe") {
			$out=str_replace("</head>","<link rel=\"stylesheet\" href=\"css/lytebox.css\" type=\"text/css\" media=\"screen\" />\n<script type=\"text/javascript\" src=\"js/lytebox.js\"></script>\n</head>",$out);
			$bb=trim(substr($pagearray1[0],9));
			$aa=explode(" ",$bb);
			if($aa[3]!="") $out.= lyteframe($aa[0],$aa[1],$aa[2],$aa[3]);
			elseif($aa[2]!="") $out.= lyteframe($aa[0],$aa[1],$aa[2]);
			elseif($aa[1]!="") $out.= lyteframe($aa[0],$aa[1]);
			else $out.= lyteframe($aa[0]);
		} elseif(substr($pagearray1[0],0,6)=="plugin") {
			$pluginame="./plugins/".clean(substr($pagearray1[0],6));
			if(file_exists($pluginame."/header.mod"))
				$out=str_replace("</head",file_get_contents($pluginame."/header.mod")."\n</head",$out);
			if(file_exists($pluginame."/first.mod"))
				include $pluginame."/first.mod";
			if(file_exists($pluginame."/onload.mod"))
				$out=str_replace("<body","<body onload=\"".file_get_contents($pluginame."/onload.mod")."\"",$out);
			if(file_exists("$pluginame/place.mod"))
				$out.=file_get_contents("$pluginame/place.mod");
			if(file_exists("$pluginame/include.mod")) {
				print $out;
				include "$pluginame/include.mod";
				$out="";
			}
		} elseif(substr($pagearray1[0],0,4)=="news") {
			$bb=trim(substr($pagearray1[0],4));
			$aa=explode(" ",$bb);
			if($aa[3]!="") $out.= shownews($aa[0],$aa[1],$aa[2],$aa[3]);
			elseif($aa[2]!="") $out.= shownews($aa[0],$aa[1],$aa[2]);
			elseif($aa[1]!="") $out.= shownews($aa[0],$aa[1]);
			else $out.= shownews($aa[0]);
		} elseif(substr($pagearray1[0],0,3)=="mp3") {
			$aa=explode(" ",$pagearray1[0],2);
			$out.= mp3(trim($aa[1]));
		} elseif(strpos($pagearray1[0], "videoy")!== false) {
			$aa=explode(" ",$pagearray1[0],2);
			$out.= youtube(trim($aa[1]));
		} elseif(strpos($pagearray1[0], "videog")!== false) {
			$aa=explode(" ",$pagearray1[0],2);
			$out.= googlev(trim($aa[1]));
		} else $out.="\n".html_entity_decode($pagearray1[0])."\n";
		$page=$pagearray1[1];
	}
	if($page!="") $out.=$page;
}

function mainmenu($generat, $span=0) {
	global $pagenum,$menu,$selected,$set;
	$aa="\n";
	$count=0;
	$first=true;
	while($menu[$count][0] != "") {
		if($menu[$count][1]=="0" && $menu[$count][2]=="0" && strpos($menu[$count][3],"#") === false) {
			$aa.='<li';
			if($first) {
				$first=false;
				$aa.=' class="first"';
			}
			$aa.='>';
			if($span==3) $aa.="<span>";
			$aa.='<a ';
			if($menu[$count][0]==$selected['index'])
				$aa.='class="selected" ';
			if(strpos($menu[$count][3],"*"))
				$aa.='href="'.str_replace("*", "",$menu[$count][3]).'">';
			else
				if($generat)
					$aa.='href="'.$menu[$count][3].".".$set['extension'].'">';
				else
					$aa.='href="'.$set['indexfile'].'?page='.$menu[$count][3].'">';
			if($span==2) $aa.="<span>";
			$aa.=$menu[$count][4];
			if($span==1) $aa.="<span>";
			if($span==2 || $span==1) $aa.="</span>";
			$aa.="</a>";
			if($span==3) $aa.="</span>";
			$aa.="</li>\n";
		}
		$count++;
	}
	return $aa;
}

function treemenu($generat=0) {
    global $pagenum, $menu, $selected, $extension, $set;
    $replace_chars=array(" ", ",", ".", "/", "?", "!", "-", ";", "'");
//    $out='<ul class="menu2">'."\n";
    $intend=0;
    for($count=0;$menu[$count][0] != "";$count++) {
        #$out.='mira-intend'.$intend.'mira-changed'.$changed.'mira-count'.$count.'menudecountuno'.$menu[$count][1];
        $changed=false;
        if($menu[$count][1]!="0" && $intend<1) {
            $changed=true;
            $intend=1;
            $out.='<ul class="sub">'."\n";
        }
        if($menu[$count][2]!="0" && $intend<2) {
            $changed=true;
            $intend=2;
            $out.="<ul>"."\n";
        }
        if($menu[$count][2]=="0" && $intend==2) {
            $changed=true;
            $intend--;
            $out.="</ul></li>"."\n";
        }
        if($menu[$count][1]=="0" && $intend==1) {
            $changed=true;
            $intend--;
            $out.="</ul></li>"."\n";
        }
        if($menu[$count][1]=="0" && $menu[$count][2]=="0") {
            $out.='<li class="top"><a class="top_link" id="'.str_replace($replace_chars, "_", $menu[$count][4]).'" ';
        }
        else {
            if($menu[$count][2]=="0" && $menu[$count][1]==$menu[$count+1][1]) {
                $out.='<li><a class="fly" ';
            }
            else {
                $out.="<li><a ";
            }
        }
        #if($menu[$count][4]==$selected['name'])
        #   $out.= 'class="selected" ';
        if(strpos($menu[$count][3],"*"))
            $out.='href="'.str_replace("*", "",$menu[$count][3]).'">';
        elseif($generat)
            $out.='href="'.$menu[$count][3].".".$set['extension'].'">';
        else
            $out.='href="'.$set['indexfile'].'?page='.$menu[$count][3].'">';
        if($menu[$count][1]=="0" && $menu[$count][2]=="0") {
            if($menu[$count][0]==$menu[$count+1][0]) {
                $out.='<span class="down">'.$menu[$count][4]."</span></a>"."\n";
            }
            else {
                $out.="<span>".$menu[$count][4]."</span></a></li>"."\n";
            }
        }
        else {
            if($menu[$count][2]=="0" && $menu[$count][1]==$menu[$count+1][1]) {
                $out.=$menu[$count][4]."</a>"."\n";
            }
            else {
                $out.=$menu[$count][4]."</a></li>"."\n";
            }
        }
    }
    if($intend==1) {    
        $out.="</ul>";
    }
//    $out.="</ul>";
    return $out;
}

function expmenu($generat) {
	global $pagenum,$menu,$selected,$set;
	$count=0;
	$aa="\n";
	while($menu[$count][0] != "") {
		if(($menu[$count][1]=="0" && $menu[$count][2]=="0" || $menu[$count][0]==$selected['index']) && strpos($menu[$count][3],"#") === false) {
			$aa.='<li';
			if($menu[$count][2]!="0") $aa.=" class=\"LNE_menu_doubleintend\"";
			elseif($menu[$count][1]!="0") $aa.=" class=\"LNE_menu_intend\"";
			else $aa.=" class=\"LNE_menu\"";
			$aa.="><a ";
			if($menu[$count][4]==$selected['name']) $aa.='class="selected" ';
			if(strpos($menu[$count][3],"*")) $aa.='href="'.str_replace("*", "",$menu[$count][3]).'">';
			else
				if($generat) $aa.='href="'.$menu[$count][3].".".$set['extension'].'">';
				else $aa.='href="'.$set['indexfile'].'?page='.$menu[$count][3].'">';
			$aa.=$menu[$count][4]."</a></li>\n";
		}
		$count++;
	}
	return $aa;
}

function submenu($generat) {
	global $pagenum,$menu,$selected,$set;
	$count=0;
	while($menu[$count][0] != "") {
		if($menu[$count][3]==$pagenum) {
			$m1=$menu[$count][0];
			$m2=$menu[$count][1];
			$m3=$menu[$count][2];
			if($m3) $sub=3;
			elseif($m2) $sub=2;
			else $sub=1;
			break;
		}
		$count++;
	}
	$count=0;
	$aa="\n";
	while($menu[$count][0] != "") {
		if(strpos($menu[$count][3],"#") === false) {
		if($menu[$count][0]==$selected['index'] && ($menu[$count][1]!="0" || $menu[$count][2]!="0")) {
			if(($sub==1 && $menu[$count][2]==0) || ($sub==2 && $menu[$count][0]==$m1) || ($sub==3 && $menu[$count][1]==$m2 && $menu[$count][0]==$m1)) {
			$aa.='<li><a ';
			if($menu[$count][4]==$selected['name']) $aa.='class="selected" ';
			if(strpos($menu[$count][3],"*")) $aa.='><a href="'.str_replace("*", "",$menu[$count][3]).'">'.$menu[$count][4].'</a></li>';
			else
				if($generat) $aa.='href="'.$menu[$count][3].".".$set['extension'].'">'.$menu[$count][4].'</a></li>';
				else $aa.='href="'.$set['indexfile'].'?page='.$menu[$count][3].'">'.$menu[$count][4].'</a></li>';
			}
		}
		}
		$count++;
	}
	return $aa;
}

function printheader($generate,$tmpl="-") {
global $set, $edit, $editextra, $pagenum, $selected;
if($generate) $out.=credits();
$out.="<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />\n";
$out.="<meta http-equiv='Content-Language' content='".$set['language']."' />\n";
$out.="<meta http-equiv='Content-Script-Type' content='text/javascript' />\n";
$out.="<meta http-equiv='Content-Style-Type' content='text/css' />\n";
$out.="<title>".$selected['name']." - ".$set['title']."</title>\n";
$out.="<meta name='keywords' content='".$set['keywords']."' />\n";
$out.="<meta name='description' content='";
if($selected['descr'] != "-")
	$out.=$selected['descr'];
else
	$out.=$set['description'];
$out.="' />\n";
$out.="<meta name='author' content='".$set['author']."' />\n";
$out.="<meta name='Robots' content='index,follow' />\n";
$out.="<meta http-equiv='imagetoolbar' content='no' /><!-- disable IE's image toolbar -->\n";
if(file_exists("data/news.dat"))
	$out.="<link rel=\"alternate\" type=\"application/rss+xml\" title=\"".$set['title']." RSS Feed\" href=\"LightNEasy/rss.php\" />\n";
$out.="<link rel='stylesheet' type='text/css' href='templates/";
if($selected['templ'] != "-")
	$out.=$selected['templ'];
else
	if($tmpl != "-")
		$out.=$tmpl;
	else
		$out.=$set['template'];
$out.="/style.css' />\n";
$out.="<link rel='stylesheet' type='text/css' href='css/lightneasy.css' />\n";
return $out;
}

function sitemap($generate) {
	// display the sitemap
	global $set, $pagenum, $langmessage;
	if($generate)
		return '<a href="?do=sitemap">'.$langmessage[88].'</a>';
	else
		return '<a href="'.$set['indexfile'].'?page='.$pagenum.'&amp;do=sitemap">'.$langmessage[88].'</a>';
}

function loginout() {
	// displays the login/logout link
	global $password,$set, $out, $langmessage;
	if($_SESSION[$set['password']]=="1") $out.='<a href="'.$set['homepath'].$set['indexfile'].'?do=logout" rel="nofollow">'.$langmessage[121].'</a>';
	else $out.='<a href="'.$set['homepath'].$set['indexfile'].'?do=login" rel="nofollow">'.$langmessage[120].'</a>';
}

function deletedata($array,$file,$pos,$value,$numfields) {
	$array1=$array;
	unset($array);
	$fp=fopen("data/".$file.".dat","w");
	$count=0;
	$count1=0;
	while($array1[$count][0]!="") {
		if($array1[$count][$pos]!=$value) {
			for($i=0;$i<$numfields;$i++){
				if($i==$numfields-1) fwrite($fp,$array1[$count][$i]."||");
				else fwrite($fp,$array1[$count][$i]."|");
			}
			$array[$count1]=$array1[$count];
			$count1++;
		}
		$count++;
	}
	fclose($fp);
	return $array;
}

function credits() {
global $LNEversion;
return "\n<!-- +++++++++++++++++++++++++++++++++++++++++++++++++
| LightNEasy Content Management System
| Copyright 2007-2009 Fernando Baptista
| http://www.lightneasy.org
++++++++++++++++++++++++++++++++++++++++++++++++++++++
| no database version $LNEversion
++++++++++++++++++++++++++++++++++++++++++++++++++++++
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
+++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->\n";
}
?>
