package map.ksj;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;

import javax.swing.JFrame;

/**
 * Graph Class 2005/09/23
 * 
 * @author Masayasu FUJIWARA
 */
public class Graph extends Canvas {

	// グラフ表示倍率
	// 1 / 2000 = 0.1 / 200 = 0.01 / 20 = 0.001 / 2 = 0.0005
	private float scale = 0.001f;

	private float SCALE_SENSE = 0.05f;

	private float SCALE_MAX = 0.1f;

	private float SCALE_MIN = 0.000005f;
	private int frameHeight;
	private int frameWidth;

	private int shiftX;
	private int shiftY;

	private Image offs;

	private Polygon[] data;
	/**
	 * コンストラクタ
	 * 描画のための前処理をする．
	 */
	public Graph(Polygon[] polygon) {
		
		this.shiftX = 122 * 3600000;
		this.shiftY =  20 * 3600000;
		
		this.data = polygon;
	}
	public void init() {
		double widthScale  = (double)this.getWidth()  / ((154 - 122) * 3600000);
		double heightScale = (double)this.getHeight() / (  (46 - 20) * 3600000);
		this.scale = (float)((widthScale < heightScale) ? widthScale : heightScale);
	}
	public static void main(String[] args) throws FileNotFoundException, IOException {
		final Graph graph = new Graph(new Preprocessing("../").getPolygon());
		
		final OperationMouse mouse = new OperationMouse(graph);
		
		graph.addMouseListener(mouse);
		graph.addMouseMotionListener(mouse);
		graph.addMouseWheelListener(mouse);
		graph.addKeyListener(mouse);
		// JFrame
		final JFrame frame = new JFrame("国土数値情報");
		
		// Close Setting
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		final Container c = frame.getContentPane();
		c.add(graph);
		frame.pack();
		// Size of Frame Setting
		frame.setSize(620, 550);
		frame.setVisible(true);
		graph.init();
	}
	private void drawPolygon(Graphics g, Polygon[] curves, Color color) {
		g.setColor(color);
		for (int i = 0; i < curves.length; i++) {
			int[] curveX = curves[i].xpoints;
			int[] curveY = curves[i].ypoints;
			
			int[] polygonX = new int[curves[i].npoints];
			int[] polygonY = new int[curves[i].npoints];

			for (int j = 0; j < curves[i].npoints; j++) {
				polygonX[j] = (int) ((curveX[j] - this.shiftX) * this.scale);
				polygonY[j] = this.frameHeight - (int) ((curveY[j] - this.shiftY) * this.scale);
			}
			g.fillPolygon(polygonX, polygonY, curves[i].npoints);
		}
	}

	@Override
	public void update(Graphics g) {
		paint(g);
	}
	public synchronized void paintComponents(Graphics g) {

		// オフスクリーンバッファ
		this.offs = createImage(this.frameWidth, this.frameHeight);
		
		Graphics offg = this.offs.getGraphics();

		// 行政界を描画
		this.drawPolygon(offg, this.data, Color.GREEN);
			
		// 外接長方形の描画
		// offg.setColor(Color.DARK_GRAY);
		// int x = (int) ((map.getArea().x - this.shiftX) * this.scale);
		// int y = this.frameHeight - (int) ((map.getArea().y - this.shiftY + map.getArea().height) * this.scale);
		// offg.drawRect(x, y, (int)(map.getArea().width * this.scale), (int)(map.getArea().height * this.scale));
		offg.drawString("scale : " + Float.toString(this.scale), 5, 30);
		// 訪問頂点数の表示
		((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
		g.drawImage(this.offs, 0, 0, null);
	}
	@Override
	public void paint(Graphics g) {

		this.frameHeight = this.getHeight();
		this.frameWidth = this.getWidth();
		if(this.scale < 0.001)
		this.paintComponents(g);
	}

	public void zoom(int x, int y, int d) {
		float newScale = this.scale * (1 + d * this.SCALE_SENSE);
		if (newScale > this.SCALE_MAX) {
			newScale = this.SCALE_MAX;
		} else if (newScale < this.SCALE_MIN) {
			newScale = this.SCALE_MIN;
		}
		y = this.frameHeight - y;
		this.shiftX = (int) (this.shiftX + x / this.scale - x / newScale);
		this.shiftY = (int) (this.shiftY + y / this.scale - y / newScale);

		this.scale = newScale;
		repaint();
	}
	public void printLocation(MouseEvent e) {
		float x = (e.getX() / this.scale + this.shiftX) / 3600000;
		float y = ((this.frameHeight - e.getY()) / this.scale + this.shiftY) / 3600000;
		System.out.printf("(%f, %f)\n", x, y);
	}
	// ポジションを指定する
	public void moveLocation(int dx, int dy) {
		this.shiftX -= dx / this.scale;
		this.shiftY += dy / this.scale;
		repaint();
	}
}