package map.ksj;



import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

/**
 * マウス操作 クラス
 * @author  Masayasu FUJIWARA
 */
public class OperationMouse implements MouseListener, MouseMotionListener, MouseWheelListener, KeyListener  {
	// Graph class
	private final Graph graph;
	// 押されたボタン
	private int button;
	private int x;
	private int y;
	private int dx;
	private int dy;
	public OperationMouse (Graph graph) {
		this.graph = graph;
	}
	public void mouseClicked(MouseEvent e) {
//		if(this.graph.changeBoundary(e)) {
//			this.graph.repaint();
//		}
		this.graph.printLocation(e);
	}
	public void mouseEntered(MouseEvent e) {
	}
	public void mouseExited (MouseEvent e) {
	}
	public void mousePressed (MouseEvent e) {
		this.button = e.getButton();
		this.x = e.getX();
		this.y = e.getY();
	}
	public void mouseReleased (MouseEvent e) {
		this.button = 0;
	}
	public void mouseDragged (MouseEvent e) {
		// ポインター座標変化量を計算
		this.dx = e.getX() - this.x;
		this.dy = e.getY() - this.y;
		// 変化時のポインター座標
		this.x = e.getX();
		this.y = e.getY();
		if (this.button == MouseEvent.BUTTON2) {
			// 平行移動
			this.graph.moveLocation(this.dx, this.dy);
		}
	}
	public void mouseMoved (MouseEvent e) {
	}
	public void mouseWheelMoved(MouseWheelEvent e){
		int d = e.getWheelRotation();
		this.graph.zoom(e.getX(), e.getY(), d);
	}
	// アルゴリズムを切り変える
	public void keyTyped(KeyEvent e) {
	}
	public void keyPressed(KeyEvent e) {
		switch(e.getKeyCode()) {
		case KeyEvent.VK_RIGHT:
		case KeyEvent.VK_KP_RIGHT:
			this.graph.moveLocation(-this.graph.getWidth() / 4, 0);
			break;
		case KeyEvent.VK_LEFT:
		case KeyEvent.VK_KP_LEFT:
			this.graph.moveLocation(this.graph.getWidth() / 4, 0);
			break;
		case KeyEvent.VK_UP:
		case KeyEvent.VK_KP_UP:
			this.graph.moveLocation(0, this.graph.getHeight() / 4);
			break;
		case KeyEvent.VK_DOWN:
		case KeyEvent.VK_KP_DOWN:
			this.graph.moveLocation(0, -this.graph.getHeight() / 4);
			break;
		case KeyEvent.VK_PAGE_UP:
			this.graph.zoom(this.graph.getWidth() / 2, this.graph.getHeight() / 2, 1);
			break;
		case KeyEvent.VK_PAGE_DOWN:
			this.graph.zoom(this.graph.getWidth() / 2, this.graph.getHeight() / 2, -1);
			break;
		}
		this.graph.repaint();
	}
	public void keyReleased(KeyEvent e) {
	}
}
