package map.ksj;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Warehouse {
	/**
	 * 保存フォルダ
	 */
	private final String baseDir;

	public Warehouse(String baseDir) {
		this.baseDir = baseDir;
		final File dir = new File(baseDir);
		
		if(!dir.isDirectory())
			dir.mkdirs();
	}
	// 数値でコードを受けた場合
	public File get(String code) {
		File file = null;
		// 圧縮ファイル
		final File zip = new File(this.baseDir +"/"+ code +"/N03-11A-"+ code + "-01.0a.zip");
		// 保存先ディレクトリ
		final File dir = new File(this.baseDir + "/" + code);

		System.out.print(code);
		try {
			if(zip.exists() || !dir.isDirectory() || dir.list().length == 0) {
				dir.mkdir();
				this.download(code, zip);
			}
			if(zip.exists()) {
				// ファイルの展開
				file = this.extract(zip);
				if(!zip.delete()){
					System.out.print(" / zip delete failed.");
				}
			}else if(dir.isDirectory() && dir.list()[0].endsWith(".txt")) {
				file = dir.listFiles()[0];
			}else{
				throw new IOException();
			}
			System.out.println();
		}catch(FileNotFoundException e) {
			e.printStackTrace();
			System.exit(1);
		}catch(IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
		return file;
	}
	private void download(String code, File file) throws MalformedURLException, IOException, FileNotFoundException {
		final URL url = new URL("http://nlftp.mlit.go.jp/ksj/dls/data/N03-11A-" + code + "-01.0a.zip");

		// ファイルのチェック（ファイルサイズの確認）
		if(url.openConnection().getContentLength() != file.length()) {
			System.out.print(" / download");
			final long start = System.currentTimeMillis();
			// ダウンロード
			this.copy(url.openStream(), new FileOutputStream(file));
			System.out.printf(": %dms", (System.currentTimeMillis() - start));
		}
	}
	// ファイルのコピー
	private void copy(InputStream in, OutputStream out) throws IOException {
		final byte buf[] = new byte[1024];
		int size;
		while ((size = in.read(buf)) != -1) {
			out.write(buf, 0, size);
		}
		out.close();
	}
	// ファイルを展開して展開したファイルの配列を返す
	private File extract(File file) throws FileNotFoundException, IOException {
		final long start = System.currentTimeMillis();

		boolean isExtracted = false;

		final ZipInputStream in = new ZipInputStream(new FileInputStream(file));

		ZipEntry entry;
		
		File extracted = null;
		while ((entry = in.getNextEntry()) != null) {
			if(extracted == null && entry.getName().endsWith(".txt")) {
				// 出力先ファイル
				final File outFile = new File(file.getParent() + "/"+ entry.getName());
				if(entry.getName().endsWith("/")) {
					if(outFile.isDirectory()) {
						continue;
					}else{
						System.err.println("Error!!");
						System.exit(1);
					}
				}
				// 出力先ファイル
				if (!outFile.exists()
						|| entry.getCompressedSize() != outFile.length()) {
					this.copy(in, new FileOutputStream(outFile));
					isExtracted = true;
				}
				extracted = outFile;
			}else if(entry.getName().endsWith(".txt")) {
				throw new IOException();
			}
		}
		in.close();
		final long end = System.currentTimeMillis();
		if (isExtracted) {
			System.out.printf(" / extract: %dms", end - start);
		}
		return extracted;
	}
}
