package map.route;

import java.util.Comparator;

import map.data.Node;

public class HeuristicComparator implements Comparator<HeapMap.Entry> {
	private HeuristicEstimate heuristic;
	private Node terminal;
	public HeuristicComparator(HeuristicEstimate heuristic, Node terminal) {
		this.heuristic = heuristic;
		this.terminal = terminal;
	}
	public int compare(HeapMap.Entry o1, HeapMap.Entry o2) {
		double d1 = o1.getValue() + this.heuristic.get(o1.getKey(), this.terminal);
		double d2 = o2.getValue() + this.heuristic.get(o2.getKey(), this.terminal);
		if(d1 < d2) {
			return -1;
		} else if(d1 > d2) {
			return 1;
		} else {
			return 0;
		}
	}
}
